/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.sql.SQLException;
import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.RealizingFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.biosql.BioSQLEntryChangeHub;
import org.biojava.bio.seq.db.biosql.BioSQLFeature;
import org.biojava.bio.seq.db.biosql.BioSQLFeatureReceiver;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceI;
import org.biojava.bio.seq.db.biosql.BioSQLStrandedFeature;
import org.biojava.bio.seq.db.biosql.FeaturesSQL;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

class BioSQLAllFeatures
implements FeatureHolder,
RealizingFeatureHolder {
    private Sequence seq;
    private BioSQLSequenceDB seqDB;
    private int bioentry_id;
    private SimpleFeatureHolder features;

    BioSQLAllFeatures(Sequence seq, BioSQLSequenceDB seqDB, int bioentry_id) {
        this.seq = seq;
        this.seqDB = seqDB;
        this.bioentry_id = bioentry_id;
    }

    @Override
    public FeatureFilter getSchema() {
        return FeatureFilter.top_level;
    }

    @Override
    public Iterator features() {
        return this.getFeatures().features();
    }

    @Override
    public int countFeatures() {
        return this.getFeatures().countFeatures();
    }

    @Override
    public boolean containsFeature(Feature f) {
        return this.getFeatures().containsFeature(f);
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.getFeatures().filter(ff, recurse);
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff) {
        return this.getFeatures().filter(ff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature createFeature(Feature.Template ft) throws ChangeVetoException, BioException {
        Feature f = this.realizeFeature(this.seq, ft);
        BioSQLEntryChangeHub entryHub = ((BioSQLSequenceI)this.seq).getSequenceDB().getEntryChangeHub();
        ChangeEvent cev = new ChangeEvent(this.seq, FeatureHolder.FEATURES, f);
        BioSQLEntryChangeHub bioSQLEntryChangeHub = entryHub;
        synchronized (bioSQLEntryChangeHub) {
            entryHub.firePreChange(cev);
            this.seqDB.getFeaturesSQL().persistFeature(f, -1, this.bioentry_id);
            if (this.features != null) {
                this.getFeatures().addFeature(f);
            }
            entryHub.firePostChange(cev);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFeature(Feature f) throws ChangeVetoException, BioException {
        SimpleFeatureHolder fh = this.getFeatures();
        if (!fh.containsFeature(f)) {
            throw new ChangeVetoException("Feature doesn't come from this sequence");
        }
        if (!(f instanceof BioSQLFeature)) {
            throw new ChangeVetoException("This isn't a normal BioSQL feature");
        }
        BioSQLEntryChangeHub entryHub = ((BioSQLSequenceI)this.seq).getSequenceDB().getEntryChangeHub();
        ChangeEvent cev = new ChangeEvent(this.seq, FeatureHolder.FEATURES, f);
        BioSQLEntryChangeHub bioSQLEntryChangeHub = entryHub;
        synchronized (bioSQLEntryChangeHub) {
            entryHub.firePreChange(cev);
            this.seqDB.getFeaturesSQL().removeFeature((BioSQLFeature)f);
            fh.removeFeature(f);
            entryHub.firePostChange(cev);
        }
    }

    protected synchronized SimpleFeatureHolder getFeatures() {
        if (this.features == null) {
            try {
                this.features = new SimpleFeatureHolder();
                FeaturesSQL adaptor = this.seqDB.getFeaturesSQL();
                adaptor.retrieveFeatures(this.bioentry_id, new FeatureReceiver(), null, -1, -1);
            }
            catch (SQLException ex) {
                throw new BioRuntimeException("SQL error while reading features", ex);
            }
            catch (BioException ex) {
                throw new BioRuntimeException(ex);
            }
        }
        return this.features;
    }

    private BioSQLFeature _realizeFeature(FeatureHolder parent, Feature.Template templ) throws BioException {
        if (parent != this.seq && !this.seqDB.isHierarchySupported()) {
            throw new BioException("This database doesn't support feature hierarchy.  Please create a seqfeature_relationship table");
        }
        if (templ instanceof StrandedFeature.Template && this.seq.getAlphabet() == DNATools.getDNA()) {
            return new BioSQLStrandedFeature(this.seq, parent, (StrandedFeature.Template)templ);
        }
        return new BioSQLFeature(this.seq, parent, templ);
    }

    @Override
    public Feature realizeFeature(FeatureHolder parent, Feature.Template templ) throws BioException {
        return this._realizeFeature(parent, templ);
    }

    @Override
    public void addChangeListener(ChangeListener cl) {
    }

    @Override
    public void addChangeListener(ChangeListener cl, ChangeType ct) {
    }

    @Override
    public void removeChangeListener(ChangeListener cl) {
    }

    @Override
    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
    }

    @Override
    public boolean isUnchanging(ChangeType ct) {
        return true;
    }

    private class FeatureReceiver
    extends BioSQLFeatureReceiver {
        FeatureReceiver() {
            super(BioSQLAllFeatures.this.seq);
        }

        @Override
        protected void deliverTopLevelFeature(Feature f) throws ParseException, ChangeVetoException {
            BioSQLAllFeatures.this.features.addFeature(f);
        }
    }
}

