/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.bio.seq.projection.ProjectedFeatureHolder;
import org.biojava.bio.seq.projection.TranslateFlipContext;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.ontology.OntoTools;
import org.biojava.ontology.Term;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Unchangeable;

class BioSQLComponentFeature
extends Unchangeable
implements ComponentFeature {
    private BioSQLSequenceDB seqDB;
    private Sequence parent;
    private Sequence componentSequence = null;
    private SymbolList contigedSymbols = null;
    private Location location;
    private Location componentLocation;
    private String componentName;
    private FeatureHolder projectedFeatures;
    private StrandedFeature.Strand strand;
    private String type;
    private String source;
    private boolean triedResolve = false;

    BioSQLComponentFeature(BioSQLSequenceDB seqDB, Sequence parent, ComponentFeature.Template temp, int assemblyFragmentID) {
        this.seqDB = seqDB;
        this.parent = parent;
        this.location = temp.location;
        this.componentLocation = temp.componentLocation;
        this.componentName = temp.componentSequenceName;
        this.type = temp.type;
        this.source = temp.source;
        this.strand = temp.strand;
    }

    @Override
    public Sequence getSequence() {
        return this.parent;
    }

    @Override
    public FeatureHolder getParent() {
        return this.parent;
    }

    @Override
    public StrandedFeature.Strand getStrand() {
        return this.strand;
    }

    @Override
    public void setStrand(StrandedFeature.Strand strand) throws ChangeVetoException {
        throw new ChangeVetoException(new ChangeEvent(this, STRAND, strand, this.strand), "Can't change strand as it is immutable");
    }

    @Override
    public SymbolList getSymbols() {
        if (this.contigedSymbols == null) {
            try {
                this.contigedSymbols = this.getComponentSequence().subList(this.componentLocation.getMin(), this.componentLocation.getMax());
            }
            catch (Exception ex) {
                throw new BioError(ex);
            }
        }
        return this.contigedSymbols;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location loc) throws ChangeVetoException {
        throw new ChangeVetoException(new ChangeEvent(this, LOCATION, loc, this.location), "Can't change location as it is immutable");
    }

    @Override
    public Location getComponentLocation() {
        return this.componentLocation;
    }

    @Override
    public boolean isComponentResolvable() {
        return this.getComponentSequence() != null;
    }

    @Override
    public String getComponentSequenceName() {
        return this.componentName;
    }

    @Override
    public Sequence getComponentSequence() {
        if (!this.triedResolve) {
            try {
                this.componentSequence = this.seqDB.getSequence(this.componentName);
            }
            catch (IllegalIDException ex) {
            }
            catch (BioException ex) {
                throw new BioRuntimeException("Error fetching component sequence", ex);
            }
        }
        return this.componentSequence;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Term getTypeTerm() {
        return OntoTools.ANY;
    }

    @Override
    public void setType(String type) throws ChangeVetoException {
        throw new ChangeVetoException(new ChangeEvent(this, TYPE, type, this.type), "Can't change type as it is immutable");
    }

    @Override
    public void setTypeTerm(Term type) throws ChangeVetoException {
        throw new ChangeVetoException("Can't change type as it is immutable");
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public Term getSourceTerm() {
        return OntoTools.ANY;
    }

    @Override
    public void setSource(String source) throws ChangeVetoException {
        throw new ChangeVetoException(new ChangeEvent(this, TYPE, source, this.source), "Can't change source as it is immutable");
    }

    @Override
    public void setSourceTerm(Term source) throws ChangeVetoException {
        throw new ChangeVetoException("Can't change source as it is immutable");
    }

    @Override
    public Feature.Template makeTemplate() {
        throw new BioError("FIXME");
    }

    @Override
    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    @Override
    public int countFeatures() {
        return this.getProjectedFeatures().countFeatures();
    }

    @Override
    public boolean containsFeature(Feature f) {
        return this.getProjectedFeatures().containsFeature(f);
    }

    @Override
    public Feature createFeature(Feature.Template temp) throws ChangeVetoException {
        throw new ChangeVetoException("Can't create features on components -- edit the underlying sequence instead");
    }

    @Override
    public void removeFeature(Feature f) throws ChangeVetoException {
        throw new ChangeVetoException("Can't remove features from components -- edit the underlying sequence instead");
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        if (FilterUtils.areDisjoint(ff, new FeatureFilter.ByParent(new FeatureFilter.ByClass(ComponentFeature.class)))) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getProjectedFeatures().filter(ff, recurse);
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff) {
        FeatureFilter.And childFilter = new FeatureFilter.And(new FeatureFilter.ByParent(new FeatureFilter.ByClass(ComponentFeature.class)), new FeatureFilter.Not(FeatureFilter.top_level));
        if (FilterUtils.areDisjoint(ff, childFilter)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getProjectedFeatures().filter(ff);
    }

    @Override
    public FeatureFilter getSchema() {
        return new FeatureFilter.ByParent(new FeatureFilter.ByFeature(this));
    }

    @Override
    public Iterator features() {
        return this.getProjectedFeatures().features();
    }

    protected FeatureHolder getProjectedFeatures() {
        if (this.projectedFeatures == null) {
            boolean flip;
            int translation;
            if (this.strand == StrandedFeature.NEGATIVE) {
                translation = this.location.getMax() + this.componentLocation.getMin();
                flip = true;
            } else if (this.strand == StrandedFeature.POSITIVE) {
                translation = this.location.getMin() - this.componentLocation.getMin();
                flip = false;
            } else {
                throw new BioError("No strand -- erk!");
            }
            Sequence child = this.getComponentSequence();
            this.projectedFeatures = child != null ? new ProjectedFeatureHolder(new TranslateFlipContext((FeatureHolder)this.getComponentSequence(), (FeatureHolder)this, translation, flip)) : FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.projectedFeatures;
    }
}

