/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import org.biojava.bio.Annotatable;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.biosql.BioSQLEntryChangeHub;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceAnnotation;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.IndexedChangeHub;

class BioSQLEntryAnnotationChangeHub
extends IndexedChangeHub {
    BioSQLSequenceDB seqDB;
    BioSQLEntryChangeHub entryHub;

    public BioSQLEntryAnnotationChangeHub(BioSQLSequenceDB seqDB, BioSQLEntryChangeHub entryHub) {
        this.seqDB = seqDB;
        this.entryHub = entryHub;
    }

    @Override
    protected final boolean isMyChangeEvent(ChangeEvent cev, IndexedChangeHub.ListenerMemento lm) {
        ChangeType ct = cev.getType();
        return ct.isMatchingType(lm.type);
    }

    void firePreChange(ChangeEvent cev) throws ChangeVetoException {
        BioSQLSequenceAnnotation source = (BioSQLSequenceAnnotation)cev.getSource();
        Integer bioentry_id = new Integer(source.getBioentryID());
        super.firePreChange(bioentry_id, cev);
        try {
            Sequence seq = this.seqDB.getSequence(null, bioentry_id);
            ChangeEvent pcev = new ChangeEvent(seq, Annotatable.ANNOTATION, null, null, cev);
            this.entryHub.firePreChange(pcev);
        }
        catch (BioException ex) {
            throw new BioRuntimeException("Sequence has gone missing");
        }
    }

    void firePostChange(ChangeEvent cev) {
        BioSQLSequenceAnnotation source = (BioSQLSequenceAnnotation)cev.getSource();
        Integer bioentry_id = new Integer(source.getBioentryID());
        super.firePostChange(bioentry_id, cev);
        try {
            Sequence seq = this.seqDB.getSequence(null, bioentry_id);
            ChangeEvent pcev = new ChangeEvent(seq, Annotatable.ANNOTATION, null, null, cev);
            this.entryHub.firePostChange(pcev);
        }
        catch (BioException ex) {
            throw new BioRuntimeException("Sequence has gone missing");
        }
    }
}

