/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceI;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.IndexedChangeHub;

class BioSQLEntryChangeHub
extends IndexedChangeHub {
    BioSQLSequenceDB seqDB;

    public BioSQLEntryChangeHub(BioSQLSequenceDB seqDB) {
        this.seqDB = seqDB;
    }

    @Override
    protected final boolean isMyChangeEvent(ChangeEvent cev, IndexedChangeHub.ListenerMemento lm) {
        ChangeType ct = cev.getType();
        return ct.isMatchingType(lm.type);
    }

    void addListener(int bioentry_id, ChangeListener listener, ChangeType ct) {
        Integer id = new Integer(bioentry_id);
        super.addListener(id, listener, ct);
    }

    void removeListener(int bioentry_id, ChangeListener listener, ChangeType ct) {
        Integer id = new Integer(bioentry_id);
        super.removeListener(id, listener, ct);
    }

    void firePreChange(ChangeEvent cev) throws ChangeVetoException {
        BioSQLSequenceI source = (BioSQLSequenceI)cev.getSource();
        Integer id = new Integer(source.getBioEntryID());
        super.firePreChange(id, cev);
        ChangeEvent pcev = new ChangeEvent(this.seqDB, SequenceDB.SEQUENCES, null, null, cev);
        this.seqDB.firePreChangeEvent(pcev);
    }

    void firePostChange(ChangeEvent cev) {
        BioSQLSequenceI source = (BioSQLSequenceI)cev.getSource();
        Integer id = new Integer(source.getBioEntryID());
        super.firePostChange(id, cev);
        ChangeEvent pcev = new ChangeEvent(this.seqDB, SequenceDB.SEQUENCES, null, null, cev);
        this.seqDB.firePostChangeEvent(pcev);
    }
}

