/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import org.biojava.bio.Annotatable;
import org.biojava.bio.seq.db.biosql.BioSQLFeature;
import org.biojava.bio.seq.db.biosql.BioSQLFeatureAnnotation;
import org.biojava.bio.seq.db.biosql.BioSQLFeatureChangeHub;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.IndexedChangeHub;

class BioSQLFeatureAnnotationChangeHub
extends IndexedChangeHub {
    BioSQLSequenceDB seqDB;
    BioSQLFeatureChangeHub featureHub;

    public BioSQLFeatureAnnotationChangeHub(BioSQLSequenceDB seqDB, BioSQLFeatureChangeHub featureHub) {
        this.seqDB = seqDB;
        this.featureHub = featureHub;
    }

    @Override
    protected final boolean isMyChangeEvent(ChangeEvent cev, IndexedChangeHub.ListenerMemento lm) {
        ChangeType ct = cev.getType();
        return ct.isMatchingType(lm.type);
    }

    void firePreChange(ChangeEvent cev) throws ChangeVetoException {
        BioSQLFeatureAnnotation source = (BioSQLFeatureAnnotation)cev.getSource();
        Integer feature_id = new Integer(source.getFeatureID());
        super.firePreChange(feature_id, cev);
        BioSQLFeature parent = this.seqDB.getFeatureByID(feature_id);
        ChangeEvent pcev = new ChangeEvent(parent, Annotatable.ANNOTATION, null, null, cev);
        this.featureHub.firePreChange(pcev);
    }

    void firePostChange(ChangeEvent cev) {
        BioSQLFeatureAnnotation source = (BioSQLFeatureAnnotation)cev.getSource();
        Integer feature_id = new Integer(source.getFeatureID());
        super.firePostChange(feature_id, cev);
        BioSQLFeature parent = this.seqDB.getFeatureByID(feature_id);
        ChangeEvent pcev = new ChangeEvent(parent, Annotatable.ANNOTATION, null, null, cev);
        this.featureHub.firePostChange(pcev);
    }
}

