/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.biosql.BioSQLFeature;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceI;
import org.biojava.bio.seq.db.biosql.BioSQLStrandedFeature;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOAdapter;
import org.biojava.utils.ChangeVetoException;

abstract class BioSQLFeatureReceiver
extends SeqIOAdapter {
    private List stack = new ArrayList();
    private Sequence seq;
    private BioSQLSequenceDB seqDB;

    BioSQLFeatureReceiver(Sequence seq) {
        this.seq = seq;
        this.seqDB = ((BioSQLSequenceI)seq).getSequenceDB();
    }

    BioSQLFeatureReceiver(BioSQLSequenceDB seqDB) {
        this.seq = null;
        this.seqDB = seqDB;
    }

    @Override
    public void startFeature(Feature.Template templ) throws ParseException {
        try {
            BioSQLFeature newFeature = this._realizeFeature(templ);
            this.stack.add(newFeature);
        }
        catch (BioException ex) {
            throw new ParseException(ex, "Couldn't realize feature");
        }
    }

    protected abstract void deliverTopLevelFeature(Feature var1) throws ParseException, ChangeVetoException;

    @Override
    public void endFeature() throws ParseException {
        if (this.stack.size() > 0) {
            BioSQLFeature f = (BioSQLFeature)this.stack.remove(this.stack.size() - 1);
            BioSQLFeature stackTop = this.getCurrent();
            try {
                if (stackTop == null) {
                    this.deliverTopLevelFeature(this.seqDB.canonicalizeFeature(f, f._getInternalID()));
                }
                stackTop._addFeature(f);
            }
            catch (ChangeVetoException ex) {
                throw new BioError(ex);
            }
        } else {
            throw new ParseException("start/end feature messages don't match");
        }
    }

    @Override
    public void addSequenceProperty(Object key, Object value) throws ParseException {
        if ("_biosql_internal.bioentry_id".equals(key)) {
            if (this.seq != null) {
                throw new ParseException("Attempting to set the sequence when it's already known!");
            }
            Integer bid = (Integer)value;
            try {
                this.seq = this.seqDB.getSequence(null, bid);
            }
            catch (Exception ex) {
                throw new ParseException("Non-existant sequence!");
            }
        }
    }

    @Override
    public void addFeatureProperty(Object key, Object value) throws ParseException {
        if ("_biosql_internal.feature_id".equals(key)) {
            Integer fid = (Integer)value;
            this.getCurrent()._setInternalID(fid);
        } else if ("_biosql_internal.feature_id".equals(key)) {
            Integer pid = (Integer)value;
            this.getCurrent().setParentID(pid);
        } else if ("_biosql_internal.hint_childfree".equals(key)) {
            this.getCurrent().hintChildFree();
        }
    }

    private BioSQLFeature getCurrent() {
        if (this.stack.size() > 0) {
            return (BioSQLFeature)this.stack.get(this.stack.size() - 1);
        }
        return null;
    }

    private BioSQLFeature _realizeFeature(Feature.Template templ) throws BioException {
        if (templ instanceof StrandedFeature.Template && this.seq.getAlphabet() == DNATools.getDNA()) {
            return new BioSQLStrandedFeature(this.seq, (StrandedFeature.Template)templ);
        }
        return new BioSQLFeature(this.seq, templ);
    }
}

