/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.db.IDMaker;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.biosql.BioSQLAssembly;
import org.biojava.bio.seq.db.biosql.BioSQLEntryAnnotationChangeHub;
import org.biojava.bio.seq.db.biosql.BioSQLEntryChangeHub;
import org.biojava.bio.seq.db.biosql.BioSQLFeature;
import org.biojava.bio.seq.db.biosql.BioSQLFeatureAnnotationChangeHub;
import org.biojava.bio.seq.db.biosql.BioSQLFeatureChangeHub;
import org.biojava.bio.seq.db.biosql.BioSQLFeatureReceiver;
import org.biojava.bio.seq.db.biosql.BioSQLSequence;
import org.biojava.bio.seq.db.biosql.DBHelper;
import org.biojava.bio.seq.db.biosql.FeaturesSQL;
import org.biojava.bio.seq.db.biosql.OntologySQL;
import org.biojava.bio.seq.db.biosql.OracleDBHelper;
import org.biojava.bio.seq.db.biosql.TaxonSQL;
import org.biojava.bio.seq.io.OrganismParser;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.taxa.Taxon;
import org.biojava.ontology.Ontology;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.JDBCPooledDataSource;
import org.biojava.utils.cache.Cache;
import org.biojava.utils.cache.FixedSizeCache;
import org.biojava.utils.cache.WeakValueHashMap;

public class BioSQLSequenceDB
extends AbstractChangeable
implements SequenceDB {
    private DataSource dataSource;
    private int dbid = -1;
    private String name;
    private IDMaker idmaker = new IDMaker.ByName();
    private WeakValueHashMap sequencesByName = new WeakValueHashMap();
    private WeakValueHashMap sequencesByID = new WeakValueHashMap();
    private DBHelper helper;
    private FeaturesSQL featuresSQL;
    private OntologySQL ontologySQL;
    private BioSQLEntryChangeHub entryChangeHub;
    private BioSQLEntryAnnotationChangeHub entryAnnotationChangeHub;
    private BioSQLFeatureChangeHub featureChangeHub;
    private BioSQLFeatureAnnotationChangeHub featureAnnotationChangeHub;
    private WeakValueHashMap featuresByID = new WeakValueHashMap();
    private Cache tileCache = new FixedSizeCache(10);
    private boolean hierarchyChecked = false;
    private boolean hierarchySupported = false;
    private boolean assemblyChecked = false;
    private boolean assemblySupported = false;
    private boolean bioentryPropertyChecked = false;
    private boolean bioentryPropertySupported = false;
    private boolean dbSchemaChecked = false;
    private boolean dbSchemaSupported = false;
    private boolean commentTableNameChecked = false;
    private String commentTableName = null;
    private boolean spaChecked = false;
    private boolean spaSupported = false;

    DataSource getDataSource() {
        return this.dataSource;
    }

    DBHelper getDBHelper() {
        return this.helper;
    }

    FeaturesSQL getFeaturesSQL() {
        return this.featuresSQL;
    }

    BioSQLEntryChangeHub getEntryChangeHub() {
        return this.entryChangeHub;
    }

    BioSQLEntryAnnotationChangeHub getEntryAnnotationChangeHub() {
        return this.entryAnnotationChangeHub;
    }

    BioSQLFeatureChangeHub getFeatureChangeHub() {
        return this.featureChangeHub;
    }

    BioSQLFeatureAnnotationChangeHub getFeatureAnnotationChangeHub() {
        return this.featureAnnotationChangeHub;
    }

    public BioSQLSequenceDB(String dbDriver, String dbURL, String dbUser, String dbPass, String biodatabase, boolean create) throws BioException {
        try {
            this.dataSource = JDBCPooledDataSource.getDataSource(dbDriver, dbURL, dbUser, dbPass);
        }
        catch (Exception ex) {
            throw new BioException("Error getting datasource", ex);
        }
        this.initDb(biodatabase, create);
    }

    public BioSQLSequenceDB(String dbURL, String dbUser, String dbPass, String biodatabase, boolean create) throws BioException {
        try {
            Driver drv = DriverManager.getDriver(dbURL);
            this.dataSource = JDBCPooledDataSource.getDataSource(drv.getClass().getName(), dbURL, dbUser, dbPass);
        }
        catch (Exception ex) {
            throw new BioException("Error getting datasource", ex);
        }
        this.initDb(biodatabase, create);
    }

    public BioSQLSequenceDB(DataSource ds, String biodatabase, boolean create) throws BioException {
        this.dataSource = ds;
        this.initDb(biodatabase, create);
    }

    void initDb(String biodatabase, boolean create) throws BioException {
        block17: {
            this.entryChangeHub = new BioSQLEntryChangeHub(this);
            this.entryAnnotationChangeHub = new BioSQLEntryAnnotationChangeHub(this, this.entryChangeHub);
            this.featureChangeHub = new BioSQLFeatureChangeHub(this, this.entryChangeHub);
            this.featureAnnotationChangeHub = new BioSQLFeatureAnnotationChangeHub(this, this.featureChangeHub);
            Connection conn = null;
            try {
                conn = this.dataSource.getConnection();
                conn.setAutoCommit(false);
                this.helper = DBHelper.getDBHelper(conn);
                if (!this.isDbSchemaSupported()) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex3) {
                        // empty catch block
                    }
                    throw new BioException("This database appears to be an old (pre-Singapore) BioSQL. If you need to access it, try an older BioJava snapshot (1.3pre1 or earlier)");
                }
                if (!this.isBioentryPropertySupported()) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex3) {
                        // empty catch block
                    }
                    throw new BioException("This database appears to be an old (pre-Cape-Town) BioSQL. If you need to access it, try an older BioJava snapshot");
                }
                this.featuresSQL = new FeaturesSQL(this);
                try {
                    this.ontologySQL = OntologySQL.getOntologySQL(this.dataSource, this.helper);
                }
                catch (SQLException ex) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex3) {
                        // empty catch block
                    }
                    throw new BioException("Error accessing ontologies", ex);
                }
                PreparedStatement getID = conn.prepareStatement("select biodatabase_id from biodatabase where name = ?");
                getID.setString(1, biodatabase);
                ResultSet rs = getID.executeQuery();
                if (rs.next()) {
                    this.dbid = rs.getInt(1);
                    this.name = biodatabase;
                    rs.close();
                    getID.close();
                    conn.close();
                    break block17;
                }
                rs.close();
                getID.close();
                if (create) {
                    PreparedStatement createdb = conn.prepareStatement("insert into biodatabase (name) values ( ? )");
                    createdb.setString(1, biodatabase);
                    createdb.executeUpdate();
                    conn.commit();
                    createdb.close();
                    conn.close();
                    this.dbid = this.getDBHelper().getInsertID(conn, "biodatabase", "biodatabase_id");
                    break block17;
                }
                conn.close();
                throw new BioException("Biodatabase " + biodatabase + " doesn't exist");
            }
            catch (SQLException ex) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex3) {
                        // empty catch block
                    }
                }
                throw new BioException("Error connecting to BioSQL database: " + ex.getMessage(), ex);
            }
        }
    }

    public Ontology createOntology(String name, String description) throws Exception {
        return this.ontologySQL.createOntology(name, description);
    }

    public Ontology getOntology(String name) throws Exception {
        return this.ontologySQL.getOntology(name);
    }

    public Ontology addOntology(Ontology onto) throws Exception {
        return this.ontologySQL.addOntology(onto);
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDummySequence(String id, Alphabet alphabet, int length) throws ChangeVetoException, BioException {
        BioSQLSequenceDB bioSQLSequenceDB = this;
        synchronized (bioSQLSequenceDB) {
            ChangeEvent cev = new ChangeEvent(this, SequenceDB.SEQUENCES, null);
            this.firePreChangeEvent(cev);
            this._createDummySequence(id, alphabet, length);
            this.firePostChangeEvent(cev);
        }
    }

    private void _createDummySequence(String id, Alphabet seqAlpha, int length) throws ChangeVetoException, BioException {
        int version = 1;
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            conn.setAutoCommit(false);
            PreparedStatement create_bioentry = conn.prepareStatement("insert into bioentry (biodatabase_id, name, accession, version, division) values (?, ?, ?, ?, ?)");
            create_bioentry.setInt(1, this.dbid);
            create_bioentry.setString(2, id);
            create_bioentry.setString(3, id);
            create_bioentry.setInt(4, version);
            create_bioentry.setString(5, "?");
            create_bioentry.executeUpdate();
            create_bioentry.close();
            int bioentry_id = this.getDBHelper().getInsertID(conn, "bioentry", "bioentry_id");
            PreparedStatement create_dummy = conn.prepareStatement("insert into biosequence        (bioentry_id, version, alphabet, length) values (?, ?, ?, ?)");
            create_dummy.setInt(1, bioentry_id);
            create_dummy.setInt(2, version);
            create_dummy.setString(3, seqAlpha.getName());
            create_dummy.setInt(4, length);
            create_dummy.executeUpdate();
            create_dummy.close();
            conn.commit();
            conn.close();
        }
        catch (SQLException ex) {
            boolean rolledback = false;
            if (conn != null) {
                try {
                    conn.rollback();
                    rolledback = true;
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException("Error adding dummy sequence" + (rolledback ? " (rolled back successfully)" : ""), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSequence(Sequence seq) throws ChangeVetoException, BioException {
        BioSQLSequenceDB bioSQLSequenceDB = this;
        synchronized (bioSQLSequenceDB) {
            ChangeEvent cev = new ChangeEvent(this, SequenceDB.SEQUENCES, seq);
            this.firePreChangeEvent(cev);
            this._addSequence(seq);
            this.firePostChangeEvent(cev);
        }
    }

    private void _addSequence(Sequence seq) throws ChangeVetoException, BioException {
        SymbolTokenization seqToke;
        String seqName = this.idmaker.calcID(seq);
        int version = 1;
        Alphabet seqAlpha = seq.getAlphabet();
        try {
            seqToke = seqAlpha.getTokenization("token");
        }
        catch (Exception ex) {
            throw new BioException("Can't store sequences in BioSQL unless they can be sensibly tokenized/detokenized", ex);
        }
        Connection conn = null;
        try {
            String seqstr;
            PreparedStatement create_biosequence;
            conn = this.dataSource.getConnection();
            conn.setAutoCommit(false);
            Annotation ann = seq.getAnnotation();
            PreparedStatement create_bioentry = conn.prepareStatement("insert into bioentry (biodatabase_id, name, accession, version, division) values (?, ?, ?, ?, ?)");
            create_bioentry.setInt(1, this.dbid);
            create_bioentry.setString(2, seqName);
            create_bioentry.setString(3, seqName);
            create_bioentry.setInt(4, version);
            create_bioentry.setString(5, "?");
            create_bioentry.executeUpdate();
            create_bioentry.close();
            int bioentry_id = this.getDBHelper().getInsertID(conn, "bioentry", "bioentry_id");
            DBHelper.BioSequenceStyle bs = this.getDBHelper().getBioSequenceStyle();
            if (bs == DBHelper.BIOSEQUENCE_ORACLECLOB) {
                create_biosequence = conn.prepareStatement("insert into biosequence (bioentry_id, version, length, seq, alphabet) values (?, ?, ?, empty_clob(), ?)");
                create_biosequence.setInt(1, bioentry_id);
                create_biosequence.setInt(2, version);
                create_biosequence.setInt(3, seq.length());
                seqstr = seqToke.tokenizeSymbolList(seq);
                create_biosequence.setString(4, seqAlpha.getName());
                create_biosequence.executeUpdate();
                create_biosequence.close();
                PreparedStatement retrieve_biosequence = conn.prepareStatement("select seq from biosequence where bioentry_id = ? for update");
                retrieve_biosequence.setInt(1, bioentry_id);
                ResultSet rs = retrieve_biosequence.executeQuery();
                if (!rs.next()) {
                    throw new BioRuntimeException("Could not read newly inserted sequence!");
                }
                OracleDBHelper odh = (OracleDBHelper)this.getDBHelper();
                odh.stringToClob(conn, rs, 1, seqstr);
                rs.close();
                retrieve_biosequence.close();
            } else {
                create_biosequence = conn.prepareStatement("insert into biosequence (bioentry_id, version, length, seq, alphabet) values (?, ?, ?, ?, ?)");
                create_biosequence.setInt(1, bioentry_id);
                create_biosequence.setInt(2, version);
                create_biosequence.setInt(3, seq.length());
                seqstr = seqToke.tokenizeSymbolList(seq);
                create_biosequence.setCharacterStream(4, (Reader)new StringReader(seqstr), seqstr.length());
                create_biosequence.setString(5, seqAlpha.getName());
                create_biosequence.executeUpdate();
                create_biosequence.close();
            }
            FeatureHolder features = seq;
            int num = features.countFeatures();
            if (!this.isHierarchySupported() && (features = features.filter(FeatureFilter.all, true)).countFeatures() != num) {
                System.err.println("*** Warning: feature hierarchy was lost when adding sequence to BioSQL");
            }
            this.getFeaturesSQL().persistFeatures(conn, bioentry_id, features);
            for (Map.Entry me : ann.asMap().entrySet()) {
                Object key = me.getKey();
                Object value = me.getValue();
                this.persistBioentryProperty(conn, bioentry_id, key, value, false, true);
            }
            conn.commit();
            conn.close();
        }
        catch (SQLException ex) {
            boolean rolledback = false;
            if (conn != null) {
                try {
                    conn.rollback();
                    rolledback = true;
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException("Error adding sequence: " + seq.getName() + (rolledback ? " (rolled back successfully)" : ""), ex);
        }
    }

    @Override
    public Sequence getSequence(String id) throws BioException {
        return this.getSequence(id, -1);
    }

    public Sequence getSequence(int bioentry_id) throws BioException {
        return this.getSequence(null, bioentry_id);
    }

    Sequence getSequence(String id, int bioentry_id) throws BioException {
        Sequence seq = null;
        if (id != null) {
            seq = (Sequence)this.sequencesByName.get(id);
        } else if (bioentry_id >= 0) {
            seq = (Sequence)this.sequencesByID.get(new Integer(bioentry_id));
        } else {
            throw new BioError("Neither a name nor an internal ID was supplied");
        }
        if (seq != null) {
            return seq;
        }
        Connection conn = null;
        try {
            int length;
            ResultSet rs;
            conn = this.dataSource.getConnection();
            if (bioentry_id < 0) {
                PreparedStatement get_bioentry = conn.prepareStatement("select bioentry.bioentry_id from bioentry where bioentry.accession = ? and       bioentry.biodatabase_id = ?");
                get_bioentry.setString(1, id);
                get_bioentry.setInt(2, this.dbid);
                rs = get_bioentry.executeQuery();
                if (rs.next()) {
                    bioentry_id = rs.getInt(1);
                }
                rs.close();
                get_bioentry.close();
                if (bioentry_id < 0) {
                    conn.close();
                    throw new IllegalIDException("No bioentry with accession " + id);
                }
            } else {
                PreparedStatement get_accession = conn.prepareStatement("select bioentry.accession from bioentry where bioentry.bioentry_id = ? and bioentry.biodatabase_id = ?");
                get_accession.setInt(1, bioentry_id);
                get_accession.setInt(2, this.dbid);
                rs = get_accession.executeQuery();
                if (rs.next()) {
                    id = rs.getString(1);
                }
                rs.close();
                get_accession.close();
                if (id == null) {
                    conn.close();
                    throw new IllegalIDException("No bioentry with internal ID " + bioentry_id);
                }
            }
            if (seq == null) {
                PreparedStatement get_biosequence = conn.prepareStatement("select alphabet, length from   biosequence where  bioentry_id = ?");
                get_biosequence.setInt(1, bioentry_id);
                rs = get_biosequence.executeQuery();
                if (rs.next()) {
                    String molecule = rs.getString(1).toUpperCase();
                    length = rs.getInt(2);
                    if (rs.wasNull()) {
                        length = -1;
                    }
                    seq = new BioSQLSequence(this, id, bioentry_id, molecule, length);
                }
                rs.close();
                get_biosequence.close();
            }
            if (seq == null && this.isAssemblySupported()) {
                PreparedStatement get_assembly = conn.prepareStatement("select assembly_id, length, molecule from   assembly where  bioentry_id = ?");
                get_assembly.setInt(1, bioentry_id);
                rs = get_assembly.executeQuery();
                if (rs.next()) {
                    int assembly_id = rs.getInt(1);
                    length = rs.getInt(2);
                    String molecule = rs.getString(3);
                    seq = new BioSQLAssembly(this, id, bioentry_id, assembly_id, molecule, length);
                }
                rs.close();
                get_assembly.close();
            }
            conn.close();
            if (seq != null) {
                this.sequencesByName.put(id, seq);
                this.sequencesByID.put(new Integer(bioentry_id), seq);
                return seq;
            }
        }
        catch (SQLException ex) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioException("Error accessing BioSQL tables", ex);
        }
        throw new BioException("BioEntry " + id + " exists with unknown sequence type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSequence(String id) throws ChangeVetoException, BioException {
        BioSQLSequenceDB bioSQLSequenceDB = this;
        synchronized (bioSQLSequenceDB) {
            ChangeEvent cev = new ChangeEvent(this, SequenceDB.SEQUENCES, null);
            this.firePreChangeEvent(cev);
            this._removeSequence(id);
            this.firePostChangeEvent(cev);
        }
    }

    private void _removeSequence(String id) throws BioException, ChangeVetoException {
        Sequence seq = (Sequence)this.sequencesByName.get(id);
        if (seq != null) {
            seq = null;
            try {
                Thread.sleep(100L);
                System.gc();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            seq = (Sequence)this.sequencesByName.get(id);
            if (seq != null) {
                throw new BioException("There are still references to sequence with ID " + id + " from this database.");
            }
        }
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            conn.setAutoCommit(false);
            PreparedStatement get_sequence = conn.prepareStatement("select bioentry.bioentry_id from bioentry where accession = ? and biodatabase_id = ?");
            get_sequence.setString(1, id);
            get_sequence.setInt(2, this.dbid);
            ResultSet rs = get_sequence.executeQuery();
            boolean exists = rs.next();
            if (exists) {
                DBHelper.DeleteStyle dstyle = this.getDBHelper().getDeleteStyle();
                int bioentry_id = rs.getInt(1);
                if (dstyle != DBHelper.DELETE_MYSQL4) {
                    PreparedStatement delete_rel;
                    PreparedStatement delete_fqv;
                    int sfid;
                    PreparedStatement delete_locs;
                    PreparedStatement delete_reference = conn.prepareStatement("delete from bioentry_reference where bioentry_id = ?");
                    delete_reference.setInt(1, bioentry_id);
                    delete_reference.executeUpdate();
                    delete_reference.close();
                    String commentTableName = this.getCommentTableName();
                    if (commentTableName != null) {
                        PreparedStatement delete_comment = conn.prepareStatement("delete from " + commentTableName + " where bioentry_id = ?");
                        delete_comment.setInt(1, bioentry_id);
                        delete_comment.executeUpdate();
                        delete_comment.close();
                    }
                    PreparedStatement delete_qv = conn.prepareStatement("delete from bioentry_qualifier_value where bioentry_id = ?");
                    delete_qv.setInt(1, bioentry_id);
                    delete_qv.executeUpdate();
                    delete_qv.close();
                    ArrayList<Integer> generic_ids = null;
                    if (dstyle == DBHelper.DELETE_POSTGRESQL) {
                        delete_locs = conn.prepareStatement("delete from location where location.seqfeature_id = seqfeature.seqfeature_id and seqfeature.bioentry_id = ?");
                        delete_locs.setInt(1, bioentry_id);
                        delete_locs.executeUpdate();
                        delete_locs.close();
                    } else {
                        delete_locs = conn.prepareStatement("delete from location where seqfeature_id = ?");
                        PreparedStatement get_seqfeats = conn.prepareStatement("select seqfeature_id from seqfeature where bioentry_id = ?");
                        get_seqfeats.setInt(1, bioentry_id);
                        ResultSet sfids = get_seqfeats.executeQuery();
                        generic_ids = new ArrayList<Integer>();
                        while (sfids.next()) {
                            sfid = sfids.getInt(1);
                            generic_ids.add(new Integer(sfid));
                            delete_locs.setInt(1, sfid);
                            delete_locs.executeUpdate();
                        }
                        sfids.close();
                        get_seqfeats.close();
                    }
                    delete_locs.close();
                    if (dstyle == DBHelper.DELETE_POSTGRESQL) {
                        delete_fqv = conn.prepareStatement("delete from seqfeature_qualifier_value where seqfeature_qualifier_value.seqfeature_id = seqfeature.seqfeature_id and seqfeature.bioentry_id = ?");
                        delete_fqv.setInt(1, bioentry_id);
                        delete_fqv.executeUpdate();
                    } else {
                        delete_fqv = conn.prepareStatement("delete from seqfeature_qualifier_value where seqfeature_qualifier_value.seqfeature_id = ?");
                        for (int i = 0; i < generic_ids.size(); ++i) {
                            sfid = (Integer)generic_ids.get(i);
                            delete_fqv.setInt(1, sfid);
                            delete_fqv.executeUpdate();
                        }
                    }
                    delete_fqv.close();
                    if (dstyle == DBHelper.DELETE_POSTGRESQL) {
                        delete_rel = conn.prepareStatement("delete from seqfeature_relationship where object_seqfeature_id = seqfeature.seqfeature_id and seqfeature.bioentry_id = ?");
                        delete_rel.setInt(1, bioentry_id);
                        delete_rel.executeUpdate();
                    } else {
                        delete_rel = conn.prepareStatement("delete from seqfeature_relationship where object_seqfeature_id = ?");
                        for (int i = 0; i < generic_ids.size(); ++i) {
                            int sfid2 = (Integer)generic_ids.get(i);
                            delete_rel.setInt(1, sfid2);
                            delete_rel.executeUpdate();
                        }
                    }
                    delete_rel.close();
                    PreparedStatement delete_features = conn.prepareStatement("delete from seqfeature  where bioentry_id = ?");
                    delete_features.setInt(1, bioentry_id);
                    delete_features.executeUpdate();
                    delete_features.close();
                    PreparedStatement delete_biosequence = conn.prepareStatement("delete from biosequence where bioentry_id = ?");
                    delete_biosequence.setInt(1, bioentry_id);
                    delete_biosequence.executeUpdate();
                    delete_biosequence.close();
                }
                PreparedStatement delete_entry = conn.prepareStatement("delete from bioentry where bioentry_id = ?");
                delete_entry.setInt(1, bioentry_id);
                int status = delete_entry.executeUpdate();
                if (status < 1) {
                    System.out.println("Bioentry (ID " + bioentry_id + ") failed to delete!!");
                }
                delete_entry.close();
            }
            rs.close();
            get_sequence.close();
            conn.commit();
            conn.close();
            if (!exists) {
                throw new IllegalIDException("Sequence " + id + " didn't exist");
            }
        }
        catch (SQLException ex) {
            boolean rolledback = false;
            if (conn != null) {
                try {
                    conn.rollback();
                    rolledback = true;
                }
                catch (SQLException ex2) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioException("Error removing from BioSQL tables" + (rolledback ? " (rolled back successfully)" : ""), ex);
        }
    }

    @Override
    public Set ids() {
        Connection conn = null;
        try {
            HashSet<String> _ids = new HashSet<String>();
            conn = this.dataSource.getConnection();
            PreparedStatement st = conn.prepareStatement("select bioentry.accession from bioentry where bioentry.biodatabase_id = ?");
            st.setInt(1, this.dbid);
            ResultSet rs = st.executeQuery();
            while (rs.next()) {
                _ids.add(rs.getString(1));
            }
            rs.close();
            st.close();
            conn.close();
            return Collections.unmodifiableSet(_ids);
        }
        catch (SQLException ex) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException("Error reading from BioSQL tables", ex);
        }
    }

    void persistBioentryProperty(Connection conn, int bioentry_id, Object key, Object value, boolean removeFirst, boolean silent) throws SQLException {
        if (key.equals(OrganismParser.PROPERTY_ORGANISM)) {
            int taxon_id = TaxonSQL.putTaxon(conn, this.getDBHelper(), (Taxon)value);
            if (taxon_id != -1) {
                PreparedStatement set_taxon = conn.prepareStatement("update bioentry set taxon_id = ?  where bioentry_id = ?");
                set_taxon.setInt(1, taxon_id);
                set_taxon.setInt(2, bioentry_id);
                set_taxon.executeUpdate();
                set_taxon.close();
            }
        } else {
            String keyString = key.toString();
            if (!this.isBioentryPropertySupported()) {
                if (silent) {
                    return;
                }
                throw new SQLException("Can't persist this property since the bioentry_qualifier_value table isn't available");
            }
            if (removeFirst) {
                int id = this.intern_ontology_term(conn, keyString);
                PreparedStatement remove_old_value = conn.prepareStatement("delete from bioentry_qualifier_value  where bioentry_id = ? and term_id = ?");
                remove_old_value.setInt(1, bioentry_id);
                remove_old_value.setInt(2, id);
                remove_old_value.executeUpdate();
                remove_old_value.close();
            }
            if (value != null) {
                PreparedStatement insert_new;
                if (this.isSPASupported()) {
                    insert_new = conn.prepareStatement("insert into bioentry_qualifier_value        (bioentry_id, term_id, value, rank) values (?, intern_ontology_term( ? ), ?, ?)");
                    if (value instanceof Collection) {
                        int cnt = 0;
                        Iterator i = ((Collection)value).iterator();
                        while (i.hasNext()) {
                            insert_new.setInt(1, bioentry_id);
                            insert_new.setString(2, keyString);
                            insert_new.setInt(4, ++cnt);
                            insert_new.setString(3, i.next().toString());
                            insert_new.executeUpdate();
                        }
                    } else {
                        insert_new.setInt(1, bioentry_id);
                        insert_new.setString(2, keyString);
                        insert_new.setInt(3, 1);
                        insert_new.setString(3, value.toString());
                        insert_new.executeUpdate();
                    }
                } else {
                    insert_new = conn.prepareStatement("insert into bioentry_qualifier_value        (bioentry_id, term_id, rank, value) values (?, ?, ?, ?)");
                    int termID = this.intern_ontology_term(conn, keyString);
                    if (value instanceof Collection) {
                        int cnt = 0;
                        Iterator i = ((Collection)value).iterator();
                        while (i.hasNext()) {
                            insert_new.setInt(1, bioentry_id);
                            insert_new.setInt(2, termID);
                            insert_new.setInt(3, ++cnt);
                            insert_new.setString(4, i.next().toString());
                            insert_new.executeUpdate();
                        }
                    } else {
                        insert_new.setInt(1, bioentry_id);
                        insert_new.setInt(2, termID);
                        insert_new.setInt(3, 1);
                        insert_new.setString(4, value.toString());
                        insert_new.executeUpdate();
                    }
                }
                insert_new.close();
            }
        }
    }

    int intern_ontology_term(Connection conn, String s) throws SQLException {
        String ts;
        Ontology legacy = this.ontologySQL.getLegacyOntology();
        if (legacy.containsTerm(ts = s.trim())) {
            return this.ontologySQL.termID(legacy.getTerm(ts));
        }
        try {
            return this.ontologySQL.termID(legacy.createTerm(ts, ""));
        }
        catch (Exception ex) {
            throw (SQLException)new SQLException("Couldn't create term '" + ts + "' for '" + s + "' in legacy ontology namespace").initCause(ex);
        }
    }

    String getOntologyTerm(int termId) {
        return this.ontologySQL.termForID(termId).getName();
    }

    boolean isHierarchySupported() {
        if (!this.hierarchyChecked) {
            this.hierarchySupported = this.getDBHelper().containsTable(this.dataSource, "seqfeature_relationship");
            this.hierarchyChecked = true;
        }
        return this.hierarchySupported;
    }

    boolean isAssemblySupported() {
        if (!this.assemblyChecked) {
            this.assemblySupported = this.getDBHelper().containsTable(this.dataSource, "assembly");
            this.assemblyChecked = true;
        }
        return this.assemblySupported;
    }

    boolean isBioentryPropertySupported() {
        if (!this.bioentryPropertyChecked) {
            this.bioentryPropertySupported = this.getDBHelper().containsTable(this.dataSource, "bioentry_qualifier_value");
            this.bioentryPropertyChecked = true;
        }
        return this.bioentryPropertySupported;
    }

    boolean isDbSchemaSupported() {
        if (!this.dbSchemaChecked) {
            this.dbSchemaSupported = this.getDBHelper().containsTable(this.dataSource, "location");
            this.dbSchemaChecked = true;
        }
        return this.dbSchemaSupported;
    }

    String getCommentTableName() {
        if (!this.commentTableNameChecked) {
            if (this.getDBHelper().containsTable(this.dataSource, "comment")) {
                this.commentTableName = "comment";
            } else if (this.getDBHelper().containsTable(this.dataSource, "anncomment")) {
                this.commentTableName = "anncomment";
            }
            this.commentTableNameChecked = true;
        }
        return this.commentTableName;
    }

    boolean isSPASupported() {
        if (!this.spaChecked) {
            Connection conn = null;
            try {
                this.spaSupported = false;
                conn = this.dataSource.getConnection();
                PreparedStatement ps = null;
                try {
                    int level;
                    ps = conn.prepareStatement("select biosql_accelerators_level()");
                    ResultSet rs = ps.executeQuery();
                    if (rs.next() && (level = rs.getInt(1)) >= 2) {
                        this.spaSupported = true;
                    }
                    rs.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
                if (ps != null) {
                    ps.close();
                }
                conn.close();
                this.spaChecked = true;
            }
            catch (SQLException ex) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw new BioRuntimeException(ex);
            }
        }
        return this.spaSupported;
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff) {
        Connection conn = null;
        try {
            SqlizedFilter sqf = new SqlizedFilter(ff);
            System.err.println("Doing BioSQL filter");
            System.err.println(sqf.getQuery());
            conn = this.dataSource.getConnection();
            PreparedStatement get_features = conn.prepareStatement(sqf.getQuery());
            get_features.setInt(1, this.dbid);
            ResultSet rs = get_features.executeQuery();
            String lastAcc = "";
            Sequence seq = null;
            SimpleFeatureHolder fh = new SimpleFeatureHolder();
            while (rs.next()) {
                FeatureHolder hereFeature;
                Feature f;
                String accession = rs.getString(1);
                int fid = rs.getInt(2);
                System.err.println(accession + "\t" + fid);
                if (seq == null || !lastAcc.equals(accession)) {
                    seq = this.getSequence(accession);
                }
                if (!ff.accept(f = (Feature)(hereFeature = seq.filter(new FilterByInternalID(fid), true)).features().next())) continue;
                fh.addFeature(f);
            }
            rs.close();
            get_features.close();
            conn.close();
            return fh;
        }
        catch (SQLException ex) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException("Error accessing BioSQL tables", ex);
        }
        catch (ChangeVetoException ex) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioError("Assert failed: couldn't modify internal FeatureHolder", ex);
        }
        catch (BioException ex) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException("Error fetching sequence", ex);
        }
    }

    @Override
    public SequenceIterator sequenceIterator() {
        return new SequenceIterator(){
            private Iterator pID;
            {
                this.pID = BioSQLSequenceDB.this.ids().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.pID.hasNext();
            }

            @Override
            public Sequence nextSequence() throws BioException {
                return BioSQLSequenceDB.this.getSequence((String)this.pID.next());
            }
        };
    }

    void firePreChangeEvent(ChangeEvent cev) throws ChangeVetoException {
        this.getChangeSupport(cev.getType()).firePreChangeEvent(cev);
    }

    void firePostChangeEvent(ChangeEvent cev) {
        this.getChangeSupport(cev.getType()).firePostChangeEvent(cev);
    }

    BioSQLFeature canonicalizeFeature(BioSQLFeature f, int feature_id) {
        Integer key = new Integer(feature_id);
        BioSQLFeature oldFeature = (BioSQLFeature)this.featuresByID.get(key);
        if (oldFeature != null) {
            return oldFeature;
        }
        this.featuresByID.put(key, f);
        return f;
    }

    BioSQLFeature getFeatureByID(int feature_id) {
        Integer key = new Integer(feature_id);
        BioSQLFeature f = (BioSQLFeature)this.featuresByID.get(key);
        if (f != null) {
            return f;
        }
        try {
            SingleFeatureReceiver receiver = new SingleFeatureReceiver();
            this.getFeaturesSQL().retrieveFeatures(-1, receiver, null, -1, feature_id);
            if (receiver.getFeature() == null) {
                throw new BioRuntimeException("Dangling internal_feature_id");
            }
            this.featuresByID.put(key, (BioSQLFeature)receiver.getFeature());
            return (BioSQLFeature)receiver.getFeature();
        }
        catch (SQLException ex) {
            throw new BioRuntimeException("Database error", ex);
        }
        catch (BioException ex) {
            throw new BioRuntimeException(ex);
        }
    }

    Cache getTileCache() {
        return this.tileCache;
    }

    private class SingleFeatureReceiver
    extends BioSQLFeatureReceiver {
        private Feature feature;

        private SingleFeatureReceiver() {
            super(BioSQLSequenceDB.this);
        }

        @Override
        protected void deliverTopLevelFeature(Feature f) throws ParseException {
            if (this.feature != null) {
                throw new ParseException("Expecting only a single feature");
            }
            this.feature = f;
        }

        public Feature getFeature() {
            return this.feature;
        }
    }

    private class FilterByInternalID
    implements FeatureFilter {
        private int id;

        public FilterByInternalID(int id) {
            this.id = id;
        }

        @Override
        public boolean accept(Feature f) {
            if (!(f instanceof BioSQLFeature)) {
                return false;
            }
            int intID = ((BioSQLFeature)f)._getInternalID();
            return intID == this.id;
        }
    }

    private class SqlizedFilter {
        private List tables = new ArrayList();
        private String filter;
        private int used_ot = 0;
        private int used_sfs = 0;

        SqlizedFilter(FeatureFilter ff) {
            this.filter = this.sqlizeFilter(ff, false);
        }

        private String sqlizeFilter(FeatureFilter ff, boolean negate) {
            if (ff instanceof FeatureFilter.ByType) {
                String type = ((FeatureFilter.ByType)ff).getType();
                String tableName = "ot_" + this.used_ot++;
                this.tables.add("term as " + tableName);
                return tableName + ".name " + this.eq(negate) + this.qw(type) + " and seqfeature.type_term_id = " + tableName + ".term_id";
            }
            if (ff instanceof FeatureFilter.BySource) {
                String source = ((FeatureFilter.BySource)ff).getSource();
                String tableName = "sfs_" + this.used_sfs++;
                this.tables.add("term as " + tableName);
                return tableName + ".name " + this.eq(negate) + this.qw(source) + " and seqfeature.source_term_id = " + tableName + ".term_id";
            }
            if (ff instanceof FeatureFilter.ByAnnotation) {
                return "";
            }
            if (ff instanceof FeatureFilter.And) {
                FeatureFilter.And and = (FeatureFilter.And)ff;
                FeatureFilter ff1 = and.getChild1();
                FeatureFilter ff2 = and.getChild2();
                String filter1 = this.sqlizeFilter(ff1, negate);
                String filter2 = this.sqlizeFilter(ff2, negate);
                if (filter1.length() > 0) {
                    if (filter2.length() > 0) {
                        return filter1 + " and " + filter2;
                    }
                    return filter1;
                }
                if (filter2.length() > 0) {
                    return filter2;
                }
                return "";
            }
            if (ff instanceof FeatureFilter.Not) {
                FeatureFilter child = ((FeatureFilter.Not)ff).getChild();
                return this.sqlizeFilter(child, !negate);
            }
            return "";
        }

        private String eq(boolean negate) {
            if (negate) {
                return " <> ";
            }
            return "=";
        }

        private String qw(String word) {
            return "'" + word + "'";
        }

        public String getQuery() {
            StringBuffer query = new StringBuffer();
            query.append("select bioentry.accession, seqfeature.seqfeature_id ");
            query.append("  from seqfeature, bioentry");
            Iterator i = this.tables.iterator();
            while (i.hasNext()) {
                query.append(", ");
                query.append((String)i.next());
            }
            query.append(" where bioentry.bioentry_id = seqfeature.bioentry_id");
            query.append("   and bioentry.biodatabase_id = ?");
            if (this.filter.length() > 0) {
                query.append(" and ");
                query.append(this.filter);
            }
            query.append(" order by bioentry.accession");
            return query.substring(0);
        }
    }
}

