/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.AbstractSequenceDBTest;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.bio.seq.db.biosql.OntologySQL;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.symbol.BetweenLocation;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;

public class BioSQLSequenceDBTest
extends AbstractSequenceDBTest {
    static final boolean HAVE_DB;
    protected static String DB_DRIVER;
    protected static String DB_URL;
    protected static String DB_USER;
    protected static String DB_PW;
    protected static String DB_BIODB;
    protected static String DB_CREATE_RESOURCE;
    protected static String DB_DROP_RESOURCE;
    private static String CREATE_SQL;
    private static String DROP_SQL;
    private static String[] TABLES;
    private Connection mConnection = null;

    public BioSQLSequenceDBTest(String name) {
        super(name);
    }

    @Override
    protected SequenceDB getSequenceDB() throws Exception {
        return new BioSQLSequenceDB(DB_DRIVER, DB_URL, DB_USER, DB_PW, DB_BIODB, true);
    }

    @Override
    public void setUp() throws Exception {
        this.mConnection = this.getConnection();
        this.loadSchema(this.mConnection);
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        OntologySQL.clearCache();
        this.dropSchema(this.mConnection);
        this.mConnection.close();
        this.mConnection = null;
        super.tearDown();
    }

    protected static String readAll(BufferedReader br) throws IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    protected Connection getConnection() throws SQLException {
        return DriverManager.getConnection(DB_URL, DB_USER, DB_PW);
    }

    protected void loadSchema(Connection connection) throws IOException, SQLException {
        if (CREATE_SQL == null) {
            InputStream res = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(DB_CREATE_RESOURCE);
            assert (res != null) : "Resource " + DB_CREATE_RESOURCE + " could not be located";
            BufferedReader br = new BufferedReader(new InputStreamReader(res));
            CREATE_SQL = BioSQLSequenceDBTest.readAll(br);
            br.close();
        }
        Statement st = connection.createStatement();
        st.executeQuery(CREATE_SQL);
        st.close();
    }

    protected void dropSchema(Connection connection) throws IOException, SQLException {
        if (DROP_SQL == null) {
            InputStream res = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(DB_DROP_RESOURCE);
            assert (res != null) : "Resource " + DB_DROP_RESOURCE + " could not be located";
            BufferedReader br = new BufferedReader(new InputStreamReader(res));
            DROP_SQL = BioSQLSequenceDBTest.readAll(br);
            br.close();
        }
        Statement st = connection.createStatement();
        st.executeQuery(DROP_SQL);
        st.close();
    }

    public void testSchemaSetup() throws Exception {
        Statement st;
        int i;
        Connection connection = this.getConnection();
        for (i = 0; i < TABLES.length; ++i) {
            st = connection.createStatement();
            BioSQLSequenceDBTest.assertNotNull((String)("Couldn't access " + TABLES[i]), (Object)st.executeQuery("SELECT * FROM " + TABLES[i]));
            st.close();
        }
        this.dropSchema(connection);
        for (i = 0; i < TABLES.length; ++i) {
            st = connection.createStatement();
            try {
                st.executeQuery("SELECT * FROM " + TABLES[i]);
                BioSQLSequenceDBTest.fail((String)(TABLES[i] + " still in database"));
            }
            catch (SQLException se) {
                // empty catch block
            }
            st.close();
        }
        this.loadSchema(connection);
        for (i = 0; i < TABLES.length; ++i) {
            st = connection.createStatement();
            BioSQLSequenceDBTest.assertNotNull((String)("Couldn't access " + TABLES[i]), (Object)st.executeQuery("SELECT * FROM " + TABLES[i]));
            st.close();
        }
    }

    public void testOntologyPersistence() throws Exception {
        BioSQLSequenceDB db2 = new BioSQLSequenceDB(DB_DRIVER, DB_URL, DB_USER, DB_PW, "testbiosqldb_2", true);
        this.mSequenceDB.addSequence(BioSQLSequenceDBTest.getSequence());
        db2.addSequence(BioSQLSequenceDBTest.getSequence());
    }

    public static Sequence getSequence() throws Exception {
        SymbolList sl = DNATools.createDNA("ACTGGTGTACCCCAATGGGAATATC");
        SimpleSequence sequence = new SimpleSequence(sl, null, "test_seq", null);
        sequence.createFeature(BioSQLSequenceDBTest.getFeature());
        return sequence;
    }

    private static StrandedFeature.Template getFeature() throws Exception {
        SimpleAnnotation annotation = new SimpleAnnotation();
        annotation.setProperty("Comment", "comment line");
        StrandedFeature.Template templ = new StrandedFeature.Template();
        templ.annotation = annotation;
        templ.location = new BetweenLocation(new RangeLocation(3, 4));
        templ.strand = StrandedFeature.POSITIVE;
        templ.type = "ATYPE";
        templ.source = "ASRC";
        return templ;
    }

    public static Test suite() {
        return HAVE_DB ? new TestSuite(BioSQLSequenceDBTest.class) : new TestSuite();
    }

    public static void main(String[] args) {
        TestRunner.run((Test)BioSQLSequenceDBTest.suite());
    }

    static {
        boolean haveDB = false;
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            haveDB = true;
        }
        catch (ClassNotFoundException e) {
            System.err.println("No hsqldb driver found.");
        }
        HAVE_DB = haveDB;
        DB_DRIVER = "org.hsqldb.jdbcDriver";
        DB_URL = "jdbc:hsqldb:.";
        DB_USER = "sa";
        DB_PW = "";
        DB_BIODB = "biosql";
        DB_CREATE_RESOURCE = "biosqldb-hsqldb.sql";
        DB_DROP_RESOURCE = "drop-biosqldb-hsqldb.sql";
        CREATE_SQL = null;
        DROP_SQL = null;
        TABLES = new String[]{"biodatabase", "bioentry", "bioentry_dbxref", "bioentry_path", "bioentry_qualifier_value", "bioentry_reference", "bioentry_relationship", "biosequence", "dbxref", "dbxref_qualifier_value", "location", "location_qualifier_value", "ontology", "reference", "seqfeature", "seqfeature_dbxref", "seqfeature_path", "seqfeature_qualifier_value", "seqfeature_relationship", "taxon", "taxon_name", "term", "term_dbxref", "term_path", "term_relationship", "term_synonym"};
    }
}

