/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.sql.SQLException;
import org.biojava.bio.BioError;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.biosql.BioSQLFeature;
import org.biojava.bio.seq.db.biosql.BioSQLFeatureChangeHub;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceI;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeVetoException;

class BioSQLStrandedFeature
extends BioSQLFeature
implements StrandedFeature {
    private StrandedFeature.Strand strand;

    @Override
    public StrandedFeature.Strand getStrand() {
        return this.strand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStrand(StrandedFeature.Strand strand) throws ChangeVetoException {
        BioSQLFeatureChangeHub featureHub = ((BioSQLSequenceI)this.getSequence()).getSequenceDB().getFeatureChangeHub();
        ChangeEvent cev = new ChangeEvent(this, StrandedFeature.STRAND, this.getStrand(), strand);
        BioSQLFeatureChangeHub bioSQLFeatureChangeHub = featureHub;
        synchronized (bioSQLFeatureChangeHub) {
            featureHub.firePreChange(cev);
            try {
                ((BioSQLSequenceI)this.getSequence()).getSequenceDB().getFeaturesSQL().setFeatureLocation(this._getInternalID(), this.getLocation(), strand);
            }
            catch (SQLException ex) {
                throw new BioRuntimeException("Error updating feature in database", ex);
            }
            this.strand = strand;
            featureHub.firePostChange(cev);
        }
    }

    @Override
    public SymbolList getSymbols() {
        SymbolList symList = super.getSymbols();
        if (this.getStrand() == NEGATIVE) {
            try {
                symList = DNATools.reverseComplement(symList);
            }
            catch (IllegalAlphabetException iae) {
                throw new BioError("Could not retrieve symbols for feature as the alphabet can not be complemented.", iae);
            }
        }
        return symList;
    }

    @Override
    public Feature.Template makeTemplate() {
        StrandedFeature.Template ft = new StrandedFeature.Template();
        this.fillTemplate(ft);
        return ft;
    }

    protected void fillTemplate(StrandedFeature.Template ft) {
        super.fillTemplate(ft);
        ft.strand = this.getStrand();
    }

    public BioSQLStrandedFeature(Sequence sourceSeq, FeatureHolder parent, StrandedFeature.Template template) throws IllegalAlphabetException {
        super(sourceSeq, parent, template);
        this.strand = template.strand;
    }

    public BioSQLStrandedFeature(Sequence sourceSeq, StrandedFeature.Template template) throws IllegalAlphabetException {
        super(sourceSeq, template);
        this.strand = template.strand;
    }

    public String toString() {
        String pm = this.getStrand() == POSITIVE ? "+" : "-";
        return super.toString() + " " + pm;
    }
}

