/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.emblcd;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import org.biojava.bio.seq.db.emblcd.DivisionLkpReader;

public class DivisionLkpReaderTest
extends TestCase {
    protected DivisionLkpReader div;

    public DivisionLkpReaderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        URL url = DivisionLkpReaderTest.class.getResource("division.lkp");
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(url.getFile())));
        this.div = new DivisionLkpReader(bis);
    }

    protected void tearDown() throws Exception {
        this.div.close();
    }

    public void testReadFileLength() {
        DivisionLkpReaderTest.assertTrue((366L == this.div.readFileLength() ? 1 : 0) != 0);
    }

    public void testReadRecordCount() {
        DivisionLkpReaderTest.assertTrue((3L == this.div.readRecordCount() ? 1 : 0) != 0);
    }

    public void testReadRecordLength() {
        DivisionLkpReaderTest.assertTrue((22 == this.div.readRecordLength() ? 1 : 0) != 0);
    }

    public void testReadDBName() {
        DivisionLkpReaderTest.assertEquals((String)"protDB", (String)this.div.readDBName());
    }

    public void testReadDBRelease() {
        DivisionLkpReaderTest.assertEquals((String)"0.1", (String)this.div.readDBRelease());
    }

    public void testReadDBDate() {
        DivisionLkpReaderTest.assertEquals((String)"0:0:0", (String)this.div.readDBDate());
    }

    public void testReadRecord() throws IOException {
        for (int i = 1; i <= 3; ++i) {
            Object[] rec = this.div.readRecord();
            DivisionLkpReaderTest.assertEquals((int)i, (int)((Integer)rec[0]));
            DivisionLkpReaderTest.assertEquals((String)("protDB" + i + ".aa"), (String)((String)rec[1]));
        }
    }
}

