/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.emblcd;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import org.biojava.bio.seq.db.emblcd.EntryNamIdxReader;

public class EntryNamIdxReaderTest
extends TestCase {
    protected EntryNamIdxReader ent;
    protected String[] seqID;
    protected long[] rPos;
    protected long[] sPos;
    protected int[] fileNum;

    public EntryNamIdxReaderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        URL url = EntryNamIdxReaderTest.class.getResource("entrynam.idx");
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(url.getFile())));
        this.ent = new EntryNamIdxReader(bis);
        this.seqID = new String[]{"NMA0001", "NMA0003", "NMA0004", "NMA0007", "NMA0011", "NMA0012", "NMA0013", "NMA0020", "NMA0021", "NMA0022"};
        this.rPos = new long[]{0L, 917L, 1097L, 1811L, 0L, 156L, 270L, 2379L, 0L, 283L};
        this.fileNum = new int[]{1, 1, 1, 1, 2, 2, 2, 2, 3, 3};
    }

    protected void tearDown() throws Exception {
        this.ent.close();
        this.ent = null;
    }

    public void testReadFileLength() {
        EntryNamIdxReaderTest.assertTrue((1200L == this.ent.readFileLength() ? 1 : 0) != 0);
    }

    public void testReadRecordCount() {
        EntryNamIdxReaderTest.assertTrue((30L == this.ent.readRecordCount() ? 1 : 0) != 0);
    }

    public void testReadRecordLength() {
        EntryNamIdxReaderTest.assertTrue((30 == this.ent.readRecordLength() ? 1 : 0) != 0);
    }

    public void testReadDBName() {
        EntryNamIdxReaderTest.assertEquals((String)"protDB", (String)this.ent.readDBName());
    }

    public void testReadDBRelease() {
        EntryNamIdxReaderTest.assertEquals((String)"0.1", (String)this.ent.readDBRelease());
    }

    public void testReadDBDate() {
        EntryNamIdxReaderTest.assertEquals((String)"0:0:0", (String)this.ent.readDBDate());
    }

    public void testReadRecord() throws IOException {
        for (int i = 0; i < 10; ++i) {
            Object[] rec = this.ent.readRecord();
            EntryNamIdxReaderTest.assertEquals((String)this.seqID[i], (String)((String)rec[0]));
            EntryNamIdxReaderTest.assertEquals((long)this.rPos[i], (long)((Long)rec[1]));
            EntryNamIdxReaderTest.assertEquals((long)0L, (long)((Long)rec[2]));
            EntryNamIdxReaderTest.assertEquals((int)this.fileNum[i], (int)((Integer)rec[3]));
        }
    }
}

