/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.emblcd;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import org.biojava.bio.seq.db.emblcd.EntryNamRandomAccess;

public class EntryNamRandomAccessTest
extends TestCase {
    protected EntryNamRandomAccess rand;
    protected String[] seqID;
    protected long[] rPos;
    protected long[] sPos;
    protected int[] fileNum;

    public EntryNamRandomAccessTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        URL url = EntryNamRandomAccessTest.class.getResource("entrynam.idx");
        File f = new File(url.getFile());
        this.rand = new EntryNamRandomAccess(f, 300, 30, 30L);
        this.seqID = new String[]{"NMA0001", "NMA0003", "NMA0004", "NMA0007", "NMA0011", "NMA0012", "NMA0013", "NMA0020", "NMA0021", "NMA0022"};
        this.rPos = new long[]{0L, 917L, 1097L, 1811L, 0L, 156L, 270L, 2379L, 0L, 283L};
        this.fileNum = new int[]{1, 1, 1, 1, 2, 2, 2, 2, 3, 3};
    }

    protected void tearDown() throws Exception {
        this.rand.close();
    }

    public void testFindRecord() throws IOException {
        for (int i = 0; i < 10; ++i) {
            Object[] rec = this.rand.findRecord(this.seqID[i]);
            EntryNamRandomAccessTest.assertEquals((String)this.seqID[i], (String)((String)rec[0]));
            EntryNamRandomAccessTest.assertEquals((long)this.rPos[i], (long)((Long)rec[1]));
            EntryNamRandomAccessTest.assertEquals((long)0L, (long)((Long)rec[2]));
            EntryNamRandomAccessTest.assertEquals((int)this.fileNum[i], (int)((Integer)rec[3]));
        }
    }

    public void testGetFile() {
        EntryNamRandomAccessTest.assertEquals((String)"entrynam.idx", (String)this.rand.getFile().getName());
    }
}

