/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.homol;

import junit.framework.TestCase;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.homol.SimilarityPairFeature;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeListener;

public class SimpleSimilarityPairFeatureTest
extends TestCase {
    protected Sequence qSeq;
    protected Sequence sSeq;
    protected SimilarityPairFeature qf;
    protected SimilarityPairFeature sf;

    public SimpleSimilarityPairFeatureTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.qSeq = new SimpleSequence(DNATools.createDNA("aacgtaggttccatgc"), "fragment1", "fragment1", Annotation.EMPTY_ANNOTATION);
        this.sSeq = new SimpleSequence(DNATools.createDNA("ttaacgtttttttttt"), "fragment2", "fragment2", Annotation.EMPTY_ANNOTATION);
        SimilarityPairFeature.Template qt = new SimilarityPairFeature.Template();
        qt.type = "similarity";
        qt.source = "test";
        qt.location = new RangeLocation(1, 5);
        qt.strand = StrandedFeature.POSITIVE;
        qt.score = 1.0;
        qt.annotation = Annotation.EMPTY_ANNOTATION;
        SimilarityPairFeature.Template st = new SimilarityPairFeature.Template();
        st.type = "similarity";
        st.source = "test";
        st.location = new RangeLocation(3, 7);
        st.strand = StrandedFeature.POSITIVE;
        st.score = 1.0;
        st.annotation = Annotation.EMPTY_ANNOTATION;
        qt.alignment = SimilarityPairFeature.EMPTY_PAIRWISE;
        st.alignment = SimilarityPairFeature.EMPTY_PAIRWISE;
        this.qf = (SimilarityPairFeature)this.qSeq.createFeature(qt);
        this.sf = (SimilarityPairFeature)this.sSeq.createFeature(st);
        this.sf.setSibling(this.qf);
        this.qf.setSibling(this.sf);
        this.qf.addChangeListener(ChangeListener.ALWAYS_VETO);
        this.sf.addChangeListener(ChangeListener.ALWAYS_VETO);
    }

    public void testGetType() {
        SimpleSimilarityPairFeatureTest.assertEquals((String)"similarity", (String)this.qf.getType());
        SimpleSimilarityPairFeatureTest.assertEquals((String)"similarity", (String)this.sf.getType());
    }

    public void testGetSource() {
        SimpleSimilarityPairFeatureTest.assertEquals((String)"test", (String)this.qf.getSource());
        SimpleSimilarityPairFeatureTest.assertEquals((String)"test", (String)this.sf.getSource());
    }

    public void testGetLocation() {
        SimpleSimilarityPairFeatureTest.assertEquals((int)1, (int)this.qf.getLocation().getMin());
        SimpleSimilarityPairFeatureTest.assertEquals((int)5, (int)this.qf.getLocation().getMax());
        SimpleSimilarityPairFeatureTest.assertEquals((int)3, (int)this.sf.getLocation().getMin());
        SimpleSimilarityPairFeatureTest.assertEquals((int)7, (int)this.sf.getLocation().getMax());
    }

    public void testGetStrand() {
        SimpleSimilarityPairFeatureTest.assertEquals((Object)StrandedFeature.POSITIVE, (Object)this.qf.getStrand());
        SimpleSimilarityPairFeatureTest.assertEquals((Object)StrandedFeature.POSITIVE, (Object)this.sf.getStrand());
    }

    public void testGetScore() {
        SimpleSimilarityPairFeatureTest.assertEquals((double)1.0, (double)this.qf.getScore(), (double)0.0);
        SimpleSimilarityPairFeatureTest.assertEquals((double)1.0, (double)this.sf.getScore(), (double)0.0);
    }

    public void testGetAnnotation() {
        SimpleSimilarityPairFeatureTest.assertEquals((Object)Annotation.EMPTY_ANNOTATION, (Object)this.qf.getAnnotation());
        SimpleSimilarityPairFeatureTest.assertEquals((Object)Annotation.EMPTY_ANNOTATION, (Object)this.sf.getAnnotation());
    }

    public void testGetAlignment() {
        SimpleSimilarityPairFeatureTest.assertEquals((Object)SimilarityPairFeature.EMPTY_PAIRWISE, (Object)this.qf.getAlignment());
        SimpleSimilarityPairFeatureTest.assertEquals((Object)SimilarityPairFeature.EMPTY_PAIRWISE, (Object)this.sf.getAlignment());
    }

    public void testGetSibling() {
        SimpleSimilarityPairFeatureTest.assertEquals((Object)this.qf, (Object)this.sf.getSibling());
        SimpleSimilarityPairFeatureTest.assertEquals((Object)this.sf, (Object)this.qf.getSibling());
    }
}

