/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.util.Iterator;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.GappedSequence;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleGappedSequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;

public class GappedSequenceTest
extends TestCase {
    protected Sequence seq;
    protected GappedSequence gappedSeq;

    public GappedSequenceTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.seq = new SimpleSequence(DNATools.createDNA("aacgtaggttccatgc"), "fragment1", "fragment1", Annotation.EMPTY_ANNOTATION);
        Feature.Template sft = new Feature.Template();
        sft.type = "normal";
        sft.source = "test";
        sft.annotation = Annotation.EMPTY_ANNOTATION;
        sft.location = new RangeLocation(8, 10);
        this.seq.createFeature(sft);
        sft.type = "split";
        sft.location = new RangeLocation(2, 10);
        this.seq.createFeature(sft);
        this.gappedSeq = new SimpleGappedSequence(this.seq);
        this.gappedSeq.addGapsInSource(5, 2);
    }

    public void testNonSplit() throws Exception {
        FeatureHolder fh = this.gappedSeq.filter(new FeatureFilter.ByType("normal"), false);
        Feature f = (Feature)fh.features().next();
        Location fl = f.getLocation();
        GappedSequenceTest.assertTrue((boolean)fl.isContiguous());
        GappedSequenceTest.assertEquals((int)fl.getMin(), (int)10);
        GappedSequenceTest.assertEquals((int)fl.getMax(), (int)12);
    }

    public void testSplit() throws Exception {
        FeatureHolder fh = this.gappedSeq.filter(new FeatureFilter.ByType("split"), false);
        Feature f = (Feature)fh.features().next();
        Location fl = f.getLocation();
        GappedSequenceTest.assertTrue((!fl.isContiguous() ? 1 : 0) != 0);
        GappedSequenceTest.assertEquals((int)fl.getMin(), (int)2);
        GappedSequenceTest.assertEquals((int)fl.getMax(), (int)12);
        Iterator bi = fl.blockIterator();
        TreeSet sb = new TreeSet(Location.naturalOrder);
        while (bi.hasNext()) {
            sb.add(bi.next());
        }
        GappedSequenceTest.assertEquals((int)sb.size(), (int)2);
        bi = sb.iterator();
        Location block = (Location)bi.next();
        GappedSequenceTest.assertEquals((int)block.getMin(), (int)2);
        GappedSequenceTest.assertEquals((int)block.getMax(), (int)4);
        block = (Location)bi.next();
        GappedSequenceTest.assertEquals((int)block.getMin(), (int)7);
        GappedSequenceTest.assertEquals((int)block.getMax(), (int)12);
    }

    public void testRemoveRemoteFeature() throws Exception {
        this.seq = new SimpleSequence(DNATools.createDNA("aacgtaggttccatgc"), "fragment1", "fragment1", Annotation.EMPTY_ANNOTATION);
        Feature.Template sft = new Feature.Template();
        sft.type = "normal";
        sft.source = "test";
        sft.annotation = Annotation.EMPTY_ANNOTATION;
        sft.location = new RangeLocation(8, 10);
        this.seq.createFeature(sft);
        sft.type = "split";
        sft.location = new RangeLocation(2, 10);
        this.seq.createFeature(sft);
        this.gappedSeq = new SimpleGappedSequence(this.seq);
        this.gappedSeq.addGapsInSource(5, 2);
        Feature split = (Feature)this.gappedSeq.filter(new FeatureFilter.ByType("split")).features().next();
        GappedSequenceTest.assertEquals((int)this.seq.countFeatures(), (int)2);
        this.gappedSeq.removeFeature(split);
        GappedSequenceTest.assertEquals((int)this.seq.countFeatures(), (int)1);
    }

    public void testRemoveLocalFeature() throws Exception {
        this.gappedSeq = new SimpleGappedSequence(this.seq);
        this.gappedSeq.addGapsInSource(5, 2);
        Feature.Template sft = new Feature.Template();
        sft.type = "local";
        sft.source = "test";
        sft.annotation = Annotation.EMPTY_ANNOTATION;
        sft.location = new RangeLocation(8, 10);
        this.seq.createFeature(sft);
        Feature local = (Feature)this.gappedSeq.filter(new FeatureFilter.ByType("local")).features().next();
        GappedSequenceTest.assertEquals((int)this.gappedSeq.countFeatures(), (int)3);
        this.gappedSeq.removeFeature(local);
        GappedSequenceTest.assertEquals((int)this.gappedSeq.countFeatures(), (int)2);
    }
}

