/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class LazyFilterFeatureHolder
implements FeatureHolder {
    private FeatureHolder featureHolder;
    private FeatureFilter featureFilter;
    private transient ChangeSupport changeSupport;

    public LazyFilterFeatureHolder(FeatureHolder fh, FeatureFilter ff) {
        this.featureHolder = fh;
        this.featureFilter = ff;
    }

    @Override
    public Iterator features() {
        return this.featureHolder.filter(this.featureFilter, false).features();
    }

    @Override
    public int countFeatures() {
        return this.featureHolder.filter(this.featureFilter, false).countFeatures();
    }

    @Override
    public boolean containsFeature(Feature f) {
        if (this.featureFilter.accept(f)) {
            return this.featureHolder.containsFeature(f);
        }
        return false;
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff) {
        if (FilterUtils.areDisjoint(ff, this.featureFilter)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.featureHolder.filter(new FeatureFilter.And(ff, this.featureFilter));
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        if (FilterUtils.areDisjoint(ff, this.featureFilter)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.featureHolder.filter(new FeatureFilter.And(ff, this.featureFilter), recurse);
    }

    @Override
    public Feature createFeature(Feature.Template temp) throws ChangeVetoException, BioException {
        return this.featureHolder.createFeature(temp);
    }

    @Override
    public void removeFeature(Feature f) throws ChangeVetoException, BioException {
        this.featureHolder.removeFeature(f);
    }

    protected boolean hasListeners() {
        return this.changeSupport != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChangeSupport getChangeSupport() {
        if (this.changeSupport != null) {
            return this.changeSupport;
        }
        LazyFilterFeatureHolder lazyFilterFeatureHolder = this;
        synchronized (lazyFilterFeatureHolder) {
            if (this.changeSupport == null) {
                this.changeSupport = new ChangeSupport();
            }
            this.featureHolder.addChangeListener(new LFFHChangeForwarder(), ChangeType.UNKNOWN);
        }
        return this.changeSupport;
    }

    private ChangeEvent getForwardedEvent(ChangeEvent cev) {
        Object previous;
        Object change = cev.getChange();
        if (!(change instanceof Feature)) {
            change = null;
        }
        if (!((previous = cev.getPrevious()) instanceof Feature)) {
            previous = null;
        }
        boolean forward = false;
        if (change == null && previous == null) {
            forward = true;
        } else {
            boolean bl = forward = this.isInterestingFeature((Feature)previous) || this.isInterestingFeature((Feature)change);
        }
        if (forward) {
            return new ChangeEvent(this, cev.getType(), cev.getChange(), cev.getPrevious(), cev);
        }
        return null;
    }

    private boolean isInterestingFeature(Feature f) {
        if (f == null) {
            return false;
        }
        if (this.featureFilter.accept(f)) {
            return true;
        }
        return f.filter(this.featureFilter).countFeatures() > 0;
    }

    @Override
    public final void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    @Override
    public final void addChangeListener(ChangeListener cl, ChangeType ct) {
        if (!this.isUnchanging(ct)) {
            ChangeSupport cs = this.getChangeSupport();
            cs.addChangeListener(cl, ct);
        }
    }

    @Override
    public final void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    @Override
    public final void removeChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.hasListeners()) {
            ChangeSupport cs = this.getChangeSupport();
            cs.removeChangeListener(cl, ct);
        }
    }

    @Override
    public boolean isUnchanging(ChangeType ct) {
        return this.featureHolder.isUnchanging(ct);
    }

    @Override
    public FeatureFilter getSchema() {
        return new FeatureFilter.And(this.featureFilter, new FeatureFilter.Or(this.featureHolder.getSchema(), new FeatureFilter.ByAncestor(this.featureHolder.getSchema())));
    }

    private class LFFHChangeForwarder
    implements ChangeListener {
        private LFFHChangeForwarder() {
        }

        @Override
        public void preChange(ChangeEvent cev) throws ChangeVetoException {
            ChangeEvent fcev = LazyFilterFeatureHolder.this.getForwardedEvent(cev);
            if (fcev != null) {
                LazyFilterFeatureHolder.this.getChangeSupport().firePreChangeEvent(fcev);
            }
        }

        @Override
        public void postChange(ChangeEvent cev) {
            ChangeEvent fcev = LazyFilterFeatureHolder.this.getForwardedEvent(cev);
            if (fcev != null) {
                LazyFilterFeatureHolder.this.getChangeSupport().firePostChangeEvent(fcev);
            }
        }
    }
}

