/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.util.Iterator;
import junit.framework.TestCase;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.RemoteFeature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.impl.SubSequence;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;

public class SubSequenceTest
extends TestCase {
    protected Sequence seq;
    protected Sequence subseq;

    public SubSequenceTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.seq = new SimpleSequence(DNATools.createDNA("aacgtaggttccatgc"), "fragment1", "fragment1", Annotation.EMPTY_ANNOTATION);
        Feature.Template sft = new Feature.Template();
        sft.source = "test1";
        sft.annotation = Annotation.EMPTY_ANNOTATION;
        sft.location = new RangeLocation(1, 3);
        this.seq.createFeature(sft);
        sft.type = "test2";
        sft.location = new RangeLocation(10, 12);
        this.seq.createFeature(sft);
        sft.type = "test3";
        sft.location = new RangeLocation(5, 13);
        Feature choppedFeature = this.seq.createFeature(sft);
        sft.type = "test4";
        sft.location = new RangeLocation(5, 6);
        choppedFeature.createFeature(sft);
        sft.type = "test5";
        sft.location = new RangeLocation(9, 10);
        choppedFeature.createFeature(sft);
        this.subseq = new SubSequence(this.seq, 8, 14);
    }

    public void testSymbols() throws Exception {
        SubSequenceTest.assertTrue((boolean)this.compareSymbolList(this.subseq, DNATools.createDNA("gttccat")));
    }

    public void testFeatureClipping() throws Exception {
        SubSequenceTest.assertEquals((String)"subseq.countFeatures()", (int)2, (int)this.subseq.countFeatures());
    }

    public void testFeatureProjection() throws Exception {
        Feature f = (Feature)this.subseq.filter(new FeatureFilter.Not(new FeatureFilter.ByClass(RemoteFeature.class)), false).features().next();
        Location fl = f.getLocation();
        SubSequenceTest.assertEquals((String)"projection.getMin()", (int)3, (int)fl.getMin());
        SubSequenceTest.assertEquals((String)"projection.getMax()", (int)5, (int)fl.getMax());
    }

    public void testRemoteFeature() throws Exception {
        FeatureHolder remotes = this.subseq.filter(new FeatureFilter.ByClass(RemoteFeature.class), false);
        SubSequenceTest.assertEquals((String)"One remote feature: ", (int)1, (int)remotes.countFeatures());
        Feature f = (Feature)remotes.features().next();
        SubSequenceTest.assertTrue((String)"Feature implements RemoteFeature", (boolean)(f instanceof RemoteFeature));
        RemoteFeature rf = (RemoteFeature)f;
        Location fl = rf.getLocation();
        SubSequenceTest.assertEquals((String)"remote feature getMin()", (int)1, (int)fl.getMin());
        SubSequenceTest.assertEquals((String)"remote feature getMax()", (int)6, (int)fl.getMax());
        SubSequenceTest.assertEquals((String)"remote feature name", (String)this.seq.getName(), (String)rf.getRemoteFeature().getSequence().getName());
    }

    public void testRemoteChildFeature() throws Exception {
        FeatureHolder remotes = this.subseq.filter(new FeatureFilter.ByClass(RemoteFeature.class), false);
        SubSequenceTest.assertEquals((String)"One remote feature: ", (int)1, (int)remotes.countFeatures());
        Feature f = (Feature)remotes.features().next();
        SubSequenceTest.assertTrue((String)"Feature implements RemoteFeature", (boolean)(f instanceof RemoteFeature));
        RemoteFeature rf = (RemoteFeature)f;
        SubSequenceTest.assertEquals((String)"child remote features should be pruned - counting them", (int)1, (int)rf.countFeatures());
        Feature cf = (Feature)rf.features().next();
        Location cfl = cf.getLocation();
        SubSequenceTest.assertEquals((String)"cf.getMin()", (int)2, (int)cfl.getMin());
        SubSequenceTest.assertEquals((String)"cf.getMax()", (int)3, (int)cfl.getMax());
    }

    public void testCreateOnSubsequence() throws Exception {
        Feature.Template templ = new Feature.Template();
        templ.type = "create_on_subsequence";
        templ.source = "test";
        templ.location = new RangeLocation(2, 3);
        templ.annotation = Annotation.EMPTY_ANNOTATION;
        this.subseq.createFeature(templ);
        Feature f = (Feature)this.seq.filter(new FeatureFilter.ByType("create_on_subsequence"), false).features().next();
        Location fl = f.getLocation();
        SubSequenceTest.assertEquals((String)"fl.getMin()", (int)9, (int)fl.getMin());
        SubSequenceTest.assertEquals((String)"fl.getMax()", (int)10, (int)fl.getMax());
    }

    public void testCreateOnSubsequenceFeature() throws Exception {
        Feature.Template templ = new Feature.Template();
        templ.type = "create_on_subsequence_feature";
        templ.source = "test";
        templ.location = new RangeLocation(3, 4);
        templ.annotation = Annotation.EMPTY_ANNOTATION;
        Feature subf = (Feature)this.subseq.filter(new FeatureFilter.Not(new FeatureFilter.ByClass(RemoteFeature.class)), false).features().next();
        subf.createFeature(templ);
        Feature f = (Feature)this.seq.filter(new FeatureFilter.ByType("create_on_subsequence_feature"), true).features().next();
        Location fl = f.getLocation();
        SubSequenceTest.assertEquals((int)fl.getMin(), (int)10);
        SubSequenceTest.assertEquals((int)fl.getMax(), (int)11);
    }

    public void testRemoveFeatureFromSubsequence() throws Exception {
        FeatureHolder fh = this.subseq.filter(new FeatureFilter.Not(new FeatureFilter.ByClass(RemoteFeature.class)), false);
        SubSequenceTest.assertEquals((int)fh.countFeatures(), (int)1);
        Feature f = (Feature)fh.features().next();
        this.subseq.removeFeature(f);
        fh = this.subseq.filter(new FeatureFilter.Not(new FeatureFilter.ByClass(RemoteFeature.class)), false);
        SubSequenceTest.assertEquals((int)fh.countFeatures(), (int)0);
    }

    private boolean compareSymbolList(SymbolList sl1, SymbolList sl2) {
        if (sl1.length() != sl2.length()) {
            return false;
        }
        Iterator si1 = sl1.iterator();
        Iterator si2 = sl2.iterator();
        while (si1.hasNext()) {
            if (si1.next() == si2.next()) continue;
            return false;
        }
        return true;
    }
}

