/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import junit.framework.TestCase;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.CircularView;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;

public class ViewSeqSerializationTest
extends TestCase {
    protected Sequence seq;
    protected Sequence seq2;

    public ViewSeqSerializationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.seq = new SimpleSequence(DNATools.createDNA("aacgtaggttccatgc"), "fragment1", "fragment1", Annotation.EMPTY_ANNOTATION);
        Feature.Template sft = new Feature.Template();
        sft.type = "test";
        sft.source = "test";
        sft.annotation = Annotation.EMPTY_ANNOTATION;
        sft.location = new RangeLocation(1, 3);
        this.seq.createFeature(sft);
        sft.location = new RangeLocation(10, 12);
        this.seq.createFeature(sft);
        this.seq = new CircularView(this.seq);
        sft.location = new RangeLocation(5, 8);
        this.seq.createFeature(sft);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(this.seq);
        oos.flush();
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(os.toByteArray()));
        this.seq2 = (Sequence)ois.readObject();
    }

    private boolean compareSymbolList(SymbolList sl1, SymbolList sl2) {
        if (sl1.length() != sl2.length()) {
            return false;
        }
        Iterator si1 = sl1.iterator();
        Iterator si2 = sl2.iterator();
        while (si1.hasNext()) {
            if (si1.next() == si2.next()) continue;
            return false;
        }
        return true;
    }

    public void testSymbols() throws Exception {
        ViewSeqSerializationTest.assertTrue((boolean)this.compareSymbolList(this.seq, this.seq2));
    }

    public void testAlphabet() throws Exception {
        ViewSeqSerializationTest.assertTrue((this.seq.getAlphabet() == this.seq2.getAlphabet() ? 1 : 0) != 0);
    }

    public void testFeatures() throws Exception {
        ViewSeqSerializationTest.assertTrue((this.seq.countFeatures() == this.seq2.countFeatures() ? 1 : 0) != 0);
    }
}

