/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.AlignmentFormat;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SymbolList;

public class FastaAlignmentFormat
implements AlignmentFormat {
    public static final int DNA = 1;
    public static final int PROTEIN = 2;

    @Override
    public Alignment read(BufferedReader br) {
        try {
            SequenceIterator seqs = null;
            br.mark(200);
            String line = br.readLine();
            line = br.readLine();
            br.reset();
            for (int i = 0; i < line.length(); ++i) {
                if (Character.toUpperCase(line.charAt(i)) != 'F' && Character.toUpperCase(line.charAt(i)) != 'L' && Character.toUpperCase(line.charAt(i)) != 'I' && Character.toUpperCase(line.charAt(i)) != 'P' && Character.toUpperCase(line.charAt(i)) != 'Q' && Character.toUpperCase(line.charAt(i)) != 'E') continue;
                seqs = SeqIOTools.readFastaProtein(br);
            }
            if (seqs == null) {
                seqs = SeqIOTools.readFastaDNA(br);
            }
            LinkedHashMap<String, Sequence> seqMap = new LinkedHashMap<String, Sequence>();
            Sequence curSeq = null;
            while (seqs.hasNext()) {
                curSeq = seqs.nextSequence();
                seqMap.put(curSeq.getName(), curSeq);
            }
            return new SimpleAlignment(seqMap);
        }
        catch (Exception e) {
            System.err.println("FastaAlignmentFormat.read -- " + e.getMessage());
            return null;
        }
    }

    public void write(OutputStream os, Alignment align, int fileType) throws BioException, IllegalSymbolException {
        PrintStream out = new PrintStream(os);
        ListIterator labels = align.getLabels().listIterator();
        Object curLabel = null;
        SymbolList curSeq = null;
        int lineWidth = 60;
        if (fileType != 1 && fileType != 2) {
            System.out.println("FastaAlignment.write -- File type not recognized.");
            return;
        }
        while (labels.hasNext()) {
            curLabel = labels.next();
            curSeq = align.symbolListForLabel(curLabel);
            out.print(">");
            out.println((Object)curLabel);
            for (int pos = 1; pos <= curSeq.length(); pos += lineWidth) {
                int end = Math.min(pos + lineWidth - 1, curSeq.length());
                out.println(curSeq.subStr(pos, end));
            }
        }
    }

    public void writeDna(OutputStream os, Alignment align) throws BioException, IllegalSymbolException {
        this.write(os, align, 1);
    }

    public void writeProtein(OutputStream os, Alignment align) throws BioException, IllegalSymbolException {
        this.write(os, align, 2);
    }
}

