/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.GenbankFileFormer;
import org.biojava.bio.seq.io.SeqFileFormer;
import org.biojava.bio.symbol.BetweenLocation;
import org.biojava.bio.symbol.CircularLocation;
import org.biojava.bio.symbol.FuzzyLocation;
import org.biojava.bio.symbol.FuzzyPointLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;

public class LocationFormatterTest
extends TestCase {
    protected static final StrandedFeature.Strand PLUS = StrandedFeature.POSITIVE;
    protected static final StrandedFeature.Strand MINUS = StrandedFeature.NEGATIVE;
    protected SeqFileFormer fileFormer;
    protected StringBuffer sb = new StringBuffer(512);
    protected Location mSimplePointLocation;
    protected Location mRangedPointLocation;
    protected Location mBoundedPointLocation;
    protected Location mSimpleRangedLocation;
    protected Location mBoundedRangedLocation;
    protected Location mBoundedPointRangedPointRangedLocation;
    protected Location mRangedPointSimplePointRangedLocation;
    protected Location mRangedPointRangedPointRangedLocation;
    protected Location mCircularSimpleRangedLocation;
    protected Location mCircularBoundedRangedLocation;
    protected Location mCircularBoundedPointRangedPointRangedLocation;
    protected Location mCircularRangedPointSimplePointRangedLocation;
    protected Location mCircularRangedPointRangedPointRangedLocation;
    protected Location mAdjacentBetweenLocation;
    protected Location mFuzzyBetweenLocation;

    public LocationFormatterTest(String theString) {
        super(theString);
    }

    public static void main(String[] args) {
        TestRunner.run(LocationFormatterTest.class);
    }

    public void testSimplePointLocationGenbank() {
        String expected = "467";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mSimplePointLocation, PLUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testRangedPointLocationGenbank() {
        String expected = "(102.110)";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mRangedPointLocation, PLUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testBoundedPointLocationGenbank() {
        String expected = ">12";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mBoundedPointLocation, PLUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testSimpleRangedLocationGenbank() {
        String expected = "340..565";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mSimpleRangedLocation, PLUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testBoundedRangedLocationGenbank() {
        String expected = "<345..500";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mBoundedRangedLocation, PLUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testBoundedPointRangedPointRangedLocationGenbank() {
        String expected = "<94..(200.250)";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mBoundedPointRangedPointRangedLocation, PLUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testRangedPointSimplePointRangedLocationGenbank() {
        String expected = "(23.45)..600";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mRangedPointSimplePointRangedLocation, PLUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testRangedPointRangedPointRangedLocationGenbank() {
        String expected = "(122.133)..(204.221)";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mRangedPointRangedPointRangedLocation, PLUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testCircularSimpleRangedLocationGenbank() {
        String expected = "340..565";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mCircularSimpleRangedLocation, PLUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testCircularBoundedRangedLocationGenbank() {
        String expected = "<345..500";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mCircularBoundedRangedLocation, PLUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testCircularBoundedPointRangedPointRangedLocationGenbank() {
        String expected = "<94..(200.250)";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mCircularBoundedPointRangedPointRangedLocation, PLUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testCircularRangedPointSimplePointRangedLocationGenbank() {
        String expected = "(23.45)..600";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mCircularRangedPointSimplePointRangedLocation, PLUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testCircularRangedPointRangedPointRangedLocationGenbank() {
        String expected = "(122.133)..(204.221)";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mCircularRangedPointRangedPointRangedLocation, PLUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testComplementSimplePointLocationGenbank() {
        String expected = "complement(467)";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mSimplePointLocation, MINUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testComplementRangedPointLocationGenbank() {
        String expected = "complement((102.110))";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mRangedPointLocation, MINUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testComplementBoundedPointLocationGenbank() {
        String expected = "complement(>12)";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mBoundedPointLocation, MINUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testComplementSimpleRangedLocationGenbank() {
        String expected = "complement(340..565)";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mSimpleRangedLocation, MINUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testComplementBoundedRangedLocationGenbank() {
        String expected = "complement(<345..500)";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mBoundedRangedLocation, MINUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testComplementBoundedPointRangedPointRangedLocationGenbank() {
        String expected = "complement(<94..(200.250))";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mBoundedPointRangedPointRangedLocation, MINUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testComplementRangedPointSimplePointRangedLocationGenbank() {
        String expected = "complement((23.45)..600)";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mRangedPointSimplePointRangedLocation, MINUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testComplementRangedPointRangedPointRangedLocationGenbank() {
        String expected = "complement((122.133)..(204.221))";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mRangedPointRangedPointRangedLocation, MINUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testComplementCircularSimpleRangedLocationGenbank() {
        String expected = "complement(340..565)";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mCircularSimpleRangedLocation, MINUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testComplementCircularBoundedRangedLocationGenbank() {
        String expected = "complement(<345..500)";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mCircularBoundedRangedLocation, MINUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testComplementCircularBoundedPointRangedPointRangedLocationGenbank() {
        String expected = "complement(<94..(200.250))";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mCircularBoundedPointRangedPointRangedLocation, MINUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testComplementCircularRangedPointSimplePointRangedLocationGenbank() {
        String expected = "complement((23.45)..600)";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mCircularRangedPointSimplePointRangedLocation, MINUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    public void testComplementCircularRangedPointRangedPointRangedLocationGenbank() {
        String expected = "complement((122.133)..(204.221))";
        this.sb.delete(0, this.sb.length());
        String actual = this.fileFormer.formatLocation(this.sb, this.mCircularRangedPointRangedPointRangedLocation, MINUS).toString();
        LocationFormatterTest.assertEquals((String)expected, (String)actual);
    }

    protected void setUp() {
        this.fileFormer = new GenbankFileFormer();
        this.mSimplePointLocation = new PointLocation(467);
        this.mRangedPointLocation = new FuzzyPointLocation(102, 110, FuzzyPointLocation.RESOLVE_AVERAGE);
        this.mBoundedPointLocation = new FuzzyPointLocation(12, Integer.MAX_VALUE, FuzzyPointLocation.RESOLVE_AVERAGE);
        this.mSimpleRangedLocation = new RangeLocation(340, 565);
        this.mBoundedRangedLocation = new FuzzyLocation(Integer.MIN_VALUE, 500, 345, 500, FuzzyLocation.RESOLVE_INNER);
        this.mBoundedPointRangedPointRangedLocation = new FuzzyLocation(Integer.MIN_VALUE, 250, 94, 200, FuzzyLocation.RESOLVE_INNER);
        this.mRangedPointSimplePointRangedLocation = new FuzzyLocation(23, 600, 45, 600, FuzzyLocation.RESOLVE_AVERAGE);
        this.mRangedPointRangedPointRangedLocation = new FuzzyLocation(122, 221, 133, 204, FuzzyLocation.RESOLVE_AVERAGE);
        this.mCircularSimpleRangedLocation = new CircularLocation(this.mSimpleRangedLocation, 1000);
        this.mCircularBoundedRangedLocation = new CircularLocation(this.mBoundedRangedLocation, 1000);
        this.mCircularBoundedPointRangedPointRangedLocation = new CircularLocation(this.mBoundedPointRangedPointRangedLocation, 1000);
        this.mCircularRangedPointSimplePointRangedLocation = new CircularLocation(this.mRangedPointSimplePointRangedLocation, 1000);
        this.mCircularRangedPointRangedPointRangedLocation = new CircularLocation(this.mRangedPointRangedPointRangedLocation, 1000);
        this.mCircularRangedPointRangedPointRangedLocation = new CircularLocation(this.mRangedPointRangedPointRangedLocation, 1000);
        this.mAdjacentBetweenLocation = new BetweenLocation(new RangeLocation(20, 21));
        this.mFuzzyBetweenLocation = new BetweenLocation(new RangeLocation(20, 30));
    }
}

