/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.symbol.SymbolList;

public class SeqIOToolsTest
extends TestCase {
    public SeqIOToolsTest(String name) {
        super(name);
    }

    private boolean compareSymbolLists(SymbolList sl0, SymbolList sl1) {
        if (sl0.length() != sl1.length()) {
            return false;
        }
        for (int i = 1; i <= sl0.length(); ++i) {
            if (sl0.symbolAt(i) == sl1.symbolAt(i)) continue;
            return false;
        }
        return true;
    }

    public void testDNAReadersAndWriters() {
        InputStream inputS = ((Object)((Object)this)).getClass().getResourceAsStream("/files/AY069118.fa");
        SeqIOToolsTest.assertNotNull((Object)inputS);
        SequenceIterator seqI = SeqIOTools.readFastaDNA(new BufferedReader(new InputStreamReader(inputS)));
        SeqIOToolsTest.assertTrue((boolean)seqI.hasNext());
        Sequence fastaDNASeq = null;
        try {
            fastaDNASeq = seqI.nextSequence();
        }
        catch (BioException be) {
            // empty catch block
        }
        SeqIOToolsTest.assertNotNull((Object)fastaDNASeq);
        SeqIOToolsTest.assertEquals((String)"Fasta sequence AY069118.fa had incorrect length", (int)fastaDNASeq.length(), (int)1502);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            SeqIOTools.writeFasta((OutputStream)baos, fastaDNASeq);
        }
        catch (IOException ex) {
            SeqIOToolsTest.fail((String)ex.getMessage());
        }
        inputS = ((Object)((Object)this)).getClass().getResourceAsStream("/files/AY069118.gb");
        SeqIOToolsTest.assertNotNull((Object)inputS);
        seqI = SeqIOTools.readGenbank(new BufferedReader(new InputStreamReader(inputS)));
        SeqIOToolsTest.assertTrue((boolean)seqI.hasNext());
        Sequence genbankDNASeq = null;
        try {
            genbankDNASeq = seqI.nextSequence();
        }
        catch (BioException be) {
            // empty catch block
        }
        SeqIOToolsTest.assertNotNull((Object)genbankDNASeq);
        SeqIOToolsTest.assertEquals((String)"Genbank sequence AY069118.gb had incorrect length", (int)genbankDNASeq.length(), (int)1502);
        SeqIOToolsTest.assertTrue((boolean)this.compareSymbolLists(fastaDNASeq, genbankDNASeq));
        baos = new ByteArrayOutputStream();
        try {
            SeqIOTools.writeFasta((OutputStream)baos, genbankDNASeq);
        }
        catch (IOException ex) {
            SeqIOToolsTest.fail((String)ex.getMessage());
        }
        inputS = ((Object)((Object)this)).getClass().getResourceAsStream("/files/AY069118-gb.xml");
        SeqIOToolsTest.assertNotNull((Object)inputS);
        seqI = SeqIOTools.readGenbankXml(new BufferedReader(new InputStreamReader(inputS)));
        SeqIOToolsTest.assertTrue((boolean)seqI.hasNext());
        Sequence genbankXmlDNASeq = null;
        try {
            genbankXmlDNASeq = seqI.nextSequence();
        }
        catch (BioException be) {
            // empty catch block
        }
        SeqIOToolsTest.assertNotNull((Object)genbankXmlDNASeq);
        SeqIOToolsTest.assertEquals((String)"GenbankXml sequence AY069118-gb.xml had incorrect length", (int)genbankXmlDNASeq.length(), (int)1502);
        SeqIOToolsTest.assertTrue((boolean)this.compareSymbolLists(fastaDNASeq, genbankXmlDNASeq));
        baos = new ByteArrayOutputStream();
        try {
            SeqIOTools.writeFasta((OutputStream)baos, genbankXmlDNASeq);
        }
        catch (IOException ex) {
            SeqIOToolsTest.fail((String)ex.getMessage());
        }
        inputS = ((Object)((Object)this)).getClass().getResourceAsStream("/files/AY069118.em");
        SeqIOToolsTest.assertNotNull((Object)inputS);
        seqI = SeqIOTools.readEmblNucleotide(new BufferedReader(new InputStreamReader(inputS)));
        SeqIOToolsTest.assertTrue((boolean)seqI.hasNext());
        Sequence emblDNASeq = null;
        try {
            emblDNASeq = seqI.nextSequence();
        }
        catch (BioException be) {
            // empty catch block
        }
        SeqIOToolsTest.assertNotNull((Object)emblDNASeq);
        SeqIOToolsTest.assertEquals((String)"Genbank sequence AY069118.em had incorrect length", (int)emblDNASeq.length(), (int)1502);
        SeqIOToolsTest.assertTrue((boolean)this.compareSymbolLists(fastaDNASeq, emblDNASeq));
        baos = new ByteArrayOutputStream();
        try {
            SeqIOTools.writeFasta((OutputStream)baos, emblDNASeq);
        }
        catch (IOException ex) {
            SeqIOToolsTest.fail((String)ex.getMessage());
        }
    }

    public void testProteinReadersAndWriters() {
        InputStream inputS = ((Object)((Object)this)).getClass().getResourceAsStream("/files/AAL039263.fa");
        SeqIOToolsTest.assertNotNull((Object)inputS);
        SequenceIterator seqI = SeqIOTools.readFastaProtein(new BufferedReader(new InputStreamReader(inputS)));
        SeqIOToolsTest.assertTrue((boolean)seqI.hasNext());
        Sequence fastaProteinSeq = null;
        try {
            fastaProteinSeq = seqI.nextSequence();
        }
        catch (BioException be) {
            // empty catch block
        }
        SeqIOToolsTest.assertNotNull((Object)fastaProteinSeq);
        SeqIOToolsTest.assertEquals((String)"Fasta sequence AAL39263.fa had incorrect length", (int)fastaProteinSeq.length(), (int)370);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            SeqIOTools.writeFasta((OutputStream)baos, fastaProteinSeq);
        }
        catch (IOException ex) {
            SeqIOToolsTest.fail((String)ex.getMessage());
        }
        inputS = ((Object)((Object)this)).getClass().getResourceAsStream("/files/AAL039263.gb");
        SeqIOToolsTest.assertNotNull((Object)inputS);
        seqI = SeqIOTools.readGenpept(new BufferedReader(new InputStreamReader(inputS)));
        SeqIOToolsTest.assertTrue((boolean)seqI.hasNext());
        Sequence genbankProteinSeq = null;
        try {
            genbankProteinSeq = seqI.nextSequence();
        }
        catch (BioException be) {
            // empty catch block
        }
        SeqIOToolsTest.assertNotNull((Object)genbankProteinSeq);
        SeqIOToolsTest.assertEquals((String)"Genbank sequence AAL39263.gb had incorrect length", (int)genbankProteinSeq.length(), (int)370);
        SeqIOToolsTest.assertTrue((boolean)this.compareSymbolLists(fastaProteinSeq, genbankProteinSeq));
        baos = new ByteArrayOutputStream();
        try {
            SeqIOTools.writeGenpept((OutputStream)baos, genbankProteinSeq);
        }
        catch (Exception ex) {
            SeqIOToolsTest.fail((String)ex.getMessage());
        }
        System.out.println("Testing SP read");
        System.out.println("Testing SP read");
        inputS = ((Object)((Object)this)).getClass().getResourceAsStream("/files/AAC4_HUMAN.sp");
        SeqIOToolsTest.assertNotNull((Object)inputS);
        seqI = SeqIOTools.readSwissprot(new BufferedReader(new InputStreamReader(inputS)));
        SeqIOToolsTest.assertTrue((boolean)seqI.hasNext());
        Sequence swissProteinSeq = null;
        try {
            swissProteinSeq = seqI.nextSequence();
        }
        catch (BioException be) {
            // empty catch block
        }
        SeqIOToolsTest.assertNotNull((Object)swissProteinSeq);
        SeqIOToolsTest.assertEquals((String)"SwissProt sequence AAC4_HUMAN.sp had incorrect length", (int)swissProteinSeq.length(), (int)911);
        baos = new ByteArrayOutputStream();
        try {
            SeqIOTools.writeSwissprot((OutputStream)baos, swissProteinSeq);
        }
        catch (Exception ex) {
            SeqIOToolsTest.fail((String)ex.getMessage());
        }
    }

    public void testBigDNA() {
        InputStream inputS = ((Object)((Object)this)).getClass().getResourceAsStream("/files/NC_004432.fa");
        SeqIOToolsTest.assertNotNull((Object)inputS);
        SequenceIterator seqI = SeqIOTools.readFastaDNA(new BufferedReader(new InputStreamReader(inputS)));
        SeqIOToolsTest.assertTrue((boolean)seqI.hasNext());
        Sequence bigFastaDNASeq = null;
        try {
            bigFastaDNASeq = seqI.nextSequence();
        }
        catch (BioException be) {
            // empty catch block
        }
        SeqIOToolsTest.assertNotNull((Object)bigFastaDNASeq);
        SeqIOToolsTest.assertEquals((String)"Fasta sequence NC_004432.fa had incorrect length", (int)bigFastaDNASeq.length(), (int)1358633);
        inputS = ((Object)((Object)this)).getClass().getResourceAsStream("/files/NC_004432.gb");
        SeqIOToolsTest.assertNotNull((Object)inputS);
        seqI = SeqIOTools.readGenbank(new BufferedReader(new InputStreamReader(inputS)));
        SeqIOToolsTest.assertTrue((boolean)seqI.hasNext());
        Sequence bigGenbankDNASeq = null;
        try {
            bigGenbankDNASeq = seqI.nextSequence();
        }
        catch (BioException be) {
            // empty catch block
        }
        SeqIOToolsTest.assertNotNull((Object)bigGenbankDNASeq);
        SeqIOToolsTest.assertEquals((String)"Genbank sequence NC_004432.gb had incorrect length", (int)bigGenbankDNASeq.length(), (int)1358633);
        SeqIOToolsTest.assertTrue((boolean)this.compareSymbolLists(bigFastaDNASeq, bigGenbankDNASeq));
    }

    public void testIdentifyFormat() {
        String[] formats = new String[]{"raw", "fasta", "nbrf", "ig", "embl", "genbank", "refseq", "gcg", "gff", "clustal", "msf"};
        int[] formatIds = new int[]{1, 2, 3, 4, 10, 12, 14, 15, 20, 103, 104};
        String[] alphas = new String[]{"dna", "rna", "aa", "protein"};
        int[] alphaIds = new int[]{131072, 262144, 524288, 524288};
        for (int i = 0; i < formats.length; ++i) {
            for (int j = 0; j < alphas.length; ++j) {
                SeqIOToolsTest.assertEquals((int)(formatIds[i] | alphaIds[j]), (int)SeqIOTools.identifyFormat(formats[i], alphas[j]));
            }
        }
        SeqIOToolsTest.assertEquals((int)524299, (int)SeqIOTools.identifyFormat("swissprot", "protein"));
        SeqIOToolsTest.assertEquals((int)524299, (int)SeqIOTools.identifyFormat("swissprot", "aa"));
        SeqIOToolsTest.assertEquals((int)524299, (int)SeqIOTools.identifyFormat("swiss", "protein"));
        SeqIOToolsTest.assertEquals((int)524299, (int)SeqIOTools.identifyFormat("swiss", "aa"));
        SeqIOToolsTest.assertEquals((int)524301, (int)SeqIOTools.identifyFormat("genpept", "protein"));
        SeqIOToolsTest.assertEquals((int)524301, (int)SeqIOTools.identifyFormat("genpept", "aa"));
        SeqIOToolsTest.assertEquals((int)524309, (int)SeqIOTools.identifyFormat("pdb", "protein"));
        SeqIOToolsTest.assertEquals((int)524309, (int)SeqIOTools.identifyFormat("pdb", "aa"));
        SeqIOToolsTest.assertEquals((int)1179678, (int)SeqIOTools.identifyFormat("phred", "dna"));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SeqIOToolsTest.class);
        return suite;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SeqIOToolsTest.suite());
    }
}

