/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.biosql.BioSQLSequenceDB;
import org.biojava.bio.seq.impl.DummySequence;
import org.biojava.bio.seq.io.SequenceBuilderBase;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;

public class SequenceDBSequenceBuilder
extends SequenceBuilderBase {
    public static final int ANNOTATE_EXISTING = 1;
    public static final int CREATE_DUMMYSEQ = 2;
    public static final int CREATE_REALSEQ = 3;
    private SequenceDB db;
    int mode;

    public SequenceDBSequenceBuilder(SequenceDB db, int mode) {
        this.db = db;
        this.mode = mode;
    }

    @Override
    public void addSymbols(Alphabet alpha, Symbol[] syms, int pos, int len) {
    }

    @Override
    public Sequence makeSequence() throws BioException {
        if (this.name == null) {
            System.err.println("sequence doesn't have a name!!!!  Abandoning task.");
            System.exit(1);
        }
        try {
            this.seq = this.db.getSequence(this.name);
        }
        catch (BioException be) {
            // empty catch block
        }
        if (this.mode == 1 && this.seq == null) {
            System.err.println("no existing sequence to annotate for " + this.name);
            return null;
        }
        if (this.mode == 2 || this.mode == 3) {
            if (this.seq != null) {
                System.err.println("sequence " + this.name + " already exists.");
                return null;
            }
            if (this.mode == 2) {
                int length = Integer.MAX_VALUE;
                if (this.annotation.containsProperty("length")) {
                    length = Integer.parseInt((String)this.annotation.getProperty("length"));
                }
                try {
                    if (this.db instanceof BioSQLSequenceDB) {
                        ((BioSQLSequenceDB)this.db).createDummySequence(this.name, DNATools.getDNA(), length);
                        this.seq = this.db.getSequence(this.name);
                    } else {
                        this.seq = new DummySequence(this.uri, this.name);
                    }
                }
                catch (ChangeVetoException cve) {
                    System.err.println("BioSQLSequenceDB was immutable");
                    return null;
                }
                catch (IllegalIDException iie) {
                    System.err.println("name " + this.name + " is illegal.");
                    return null;
                }
                catch (BioException be) {
                    System.err.println("Caught BioException");
                    return null;
                }
                if (this.seq == null) {
                    return null;
                }
            } else if (this.mode == 3) {
                // empty if block
            }
        }
        Set keys = this.annotation.keys();
        System.out.println("sequence is " + this.seq);
        System.out.println("sequence name is " + this.seq.getName());
        Annotation seqAnnotation = this.seq.getAnnotation();
        if (keys != null) {
            for (Object thisKey : keys) {
                try {
                    seqAnnotation.setProperty(thisKey, this.annotation.getProperty(thisKey));
                }
                catch (ChangeVetoException cve) {
                    System.err.println("BioSQLSequenceDB was immutable");
                    return null;
                }
            }
        }
        return super.makeSequence();
    }
}

