/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleAssembly;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderBase;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.StaticMemberPlaceHolder;

public class SimpleAssemblyBuilder
extends SequenceBuilderBase {
    public static final SequenceBuilderFactory FACTORY = new SSBFactory();

    private void checkSeq() {
        if (this.seq == null) {
            this.seq = new SimpleAssembly(this.name, this.uri);
        }
    }

    @Override
    public void addSymbols(Alphabet alpha, Symbol[] syms, int pos, int len) throws IllegalAlphabetException {
        System.err.println("SimpleAssemblyBuilder: illegal attempt to add symbols");
    }

    public ComponentFeature addComponentSequence(ComponentFeature.Template cft) throws BioException, ChangeVetoException {
        this.checkSeq();
        return (ComponentFeature)this.seq.createFeature(cft);
    }

    @Override
    public Sequence makeSequence() throws BioException {
        this.checkSeq();
        return super.makeSequence();
    }

    private static class SSBFactory
    implements SequenceBuilderFactory,
    Serializable {
        private SSBFactory() {
        }

        @Override
        public SequenceBuilder makeSequenceBuilder() {
            return new SimpleAssemblyBuilder();
        }

        private Object writeReplace() throws ObjectStreamException {
            try {
                return new StaticMemberPlaceHolder(SimpleAssemblyBuilder.class.getField("FACTORY"));
            }
            catch (NoSuchFieldException nsfe) {
                throw new NotSerializableException(nsfe.getMessage());
            }
        }
    }
}

