/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.HashSet;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SmartSequenceBuilder;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;

public class SmartSequenceBuilderTest
extends TestCase {
    int[] testLengths = new int[]{100, 16384, 2000000};
    int noRepeats = 3;

    public SmartSequenceBuilderTest(String string) {
        super(string);
    }

    protected Symbol[] createRandomSymbolArray(FiniteAlphabet alpha, int length) throws Exception {
        int alfaSize = alpha.size();
        AlphabetIndex indx = AlphabetManager.getAlphabetIndex(alpha);
        Random rand = new Random();
        Symbol[] array = new Symbol[length];
        for (int i = 0; i < length; ++i) {
            array[i] = indx.symbolForIndex(rand.nextInt(alfaSize));
        }
        return array;
    }

    protected boolean compareSymbolLists(SymbolList list, Symbol[] array) {
        int length = list.length();
        if (length > array.length) {
            return false;
        }
        for (int i = 1; i <= length; ++i) {
            if (list.symbolAt(i) == array[i - 1]) continue;
            return false;
        }
        return true;
    }

    protected boolean runSymbolListTest(FiniteAlphabet arrayAlpha, FiniteAlphabet symListAlpha, int length, SequenceBuilder builder) throws Exception {
        Symbol[] array = this.createRandomSymbolArray(arrayAlpha, length);
        SmartSequenceBuilderTest.assertNotNull((Object)array);
        builder.addSymbols(symListAlpha, array, 0, length);
        Sequence seq = builder.makeSequence();
        SmartSequenceBuilderTest.assertNotNull((Object)seq);
        return this.compareSymbolLists(seq, array);
    }

    private boolean runRepeatedSymbolListTests(FiniteAlphabet arrayAlpha, FiniteAlphabet symListAlpha, SequenceBuilder builder) throws Exception {
        for (int i = 0; i < this.testLengths.length; ++i) {
            int length = this.testLengths[i];
            for (int j = 0; j < this.noRepeats; ++j) {
                SmartSequenceBuilderTest.assertTrue((boolean)this.runSymbolListTest(arrayAlpha, symListAlpha, length, builder));
            }
        }
        return true;
    }

    private FiniteAlphabet generateAmbiguousDNA() {
        FiniteAlphabet dna = DNATools.getDNA();
        SimpleAlphabet ambiguous = new SimpleAlphabet();
        try {
            ambiguous.addSymbol(DNATools.a());
            ambiguous.addSymbol(DNATools.c());
            ambiguous.addSymbol(DNATools.g());
            ambiguous.addSymbol(DNATools.t());
            HashSet<Symbol> chars = new HashSet<Symbol>();
            chars.add(DNATools.a());
            chars.add(DNATools.c());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.a());
            chars.add(DNATools.g());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.a());
            chars.add(DNATools.t());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.c());
            chars.add(DNATools.g());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.c());
            chars.add(DNATools.t());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.g());
            chars.add(DNATools.t());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.a());
            chars.add(DNATools.c());
            chars.add(DNATools.g());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.a());
            chars.add(DNATools.c());
            chars.add(DNATools.t());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.a());
            chars.add(DNATools.g());
            chars.add(DNATools.t());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars = new HashSet();
            chars.add(DNATools.c());
            chars.add(DNATools.g());
            chars.add(DNATools.t());
            ambiguous.addSymbol(dna.getAmbiguity(chars));
            chars.add(DNATools.n());
            return ambiguous;
        }
        catch (IllegalSymbolException ise) {
            return null;
        }
        catch (ChangeVetoException cve) {
            return null;
        }
    }

    public void testSmartSequenceBuilder() throws Exception {
        FiniteAlphabet symListAlpha = DNATools.getDNA();
        FiniteAlphabet arrayAlpha = this.generateAmbiguousDNA();
        SmartSequenceBuilderTest.assertNotNull((Object)arrayAlpha);
        SmartSequenceBuilderTest.assertNotNull((Object)symListAlpha);
        SmartSequenceBuilderTest.assertTrue((boolean)this.runRepeatedSymbolListTests(arrayAlpha, symListAlpha, SmartSequenceBuilder.FACTORY.makeSequenceBuilder()));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SmartSequenceBuilderTest.class);
        return suite;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SmartSequenceBuilderTest.suite());
    }
}

