/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.agave;

import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.agave.AGAVEBioSeqHandler;
import org.biojava.bio.seq.io.agave.AGAVEFeatureCallbackItf;
import org.biojava.bio.seq.io.agave.AGAVEMapLocationPropHandler;
import org.biojava.bio.seq.io.agave.ElementRecognizer;
import org.biojava.bio.seq.io.agave.StAXContentHandler;
import org.biojava.bio.seq.io.agave.StAXFeatureHandler;
import org.biojava.bio.seq.io.agave.StAXHandlerFactory;
import org.biojava.bio.symbol.Location;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AGAVEFragmentOrientationHandler
extends StAXFeatureHandler
implements AGAVEFeatureCallbackItf {
    public static final StAXHandlerFactory AGAVE_FRAGMENT_ORIENTATION_HANDLER_FACTORY = new StAXHandlerFactory(){

        @Override
        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new AGAVEFragmentOrientationHandler(staxenv);
        }
    };

    AGAVEFragmentOrientationHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        this.featureListener = staxenv.featureListener;
        this.setHandlerCharacteristics("fragment_orientation", true);
        super.addHandler(new ElementRecognizer.ByLocalName("bio_sequence"), AGAVEBioSeqHandler.AGAVE_BIO_SEQ_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("map_location"), AGAVEMapLocationPropHandler.AGAVE_MAP_LOCATION_PROP_HANDLER_FACTORY);
    }

    @Override
    public void reportFeature(Location loc) {
        ((StrandedFeature.Template)this.featureTemplate).location = loc;
    }

    @Override
    public void reportStrand(StrandedFeature.Strand strand) {
        ((StrandedFeature.Template)this.featureTemplate).strand = strand;
    }

    @Override
    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        try {
            this.featureListener.startFeature(this.featureTemplate);
            String strand = attrs.getValue("on_complement_strand");
            boolean forFeature = true;
            this.setProperty("on_complement_strand", strand, forFeature);
            this.setProperty("has_5prime_end", attrs.getValue("has_5prime_end"), forFeature);
            this.setProperty("has_3prime_end", attrs.getValue("has_3prime_end"), forFeature);
            this.setProperty("is_all_BAC_vect", attrs.getValue("is_all_BAC_vect"), forFeature);
            ((StrandedFeature.Template)this.featureTemplate).strand = strand.equalsIgnoreCase("true") ? StrandedFeature.NEGATIVE : (strand.equalsIgnoreCase("false") ? StrandedFeature.POSITIVE : StrandedFeature.UNKNOWN);
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }
}

