/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.filterxml;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.TestCase;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.FramedFeature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.filterxml.XMLFilterHandler;
import org.biojava.bio.seq.io.filterxml.XMLFilterWriter;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.stax.SAX2StAXAdaptor;
import org.biojava.utils.xml.PrettyXMLWriter;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class FilterXMLTest
extends TestCase {
    XMLFilterWriter filterWriter = new XMLFilterWriter();
    XMLFilterHandler filterHandler = new XMLFilterHandler();

    public FilterXMLTest(String theString) {
        super(theString);
    }

    private FeatureFilter roundTripFilter(FeatureFilter ff) throws Exception {
        CharArrayWriter caw = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(caw);
        PrettyXMLWriter xw = new PrettyXMLWriter(pw);
        this.filterWriter.writeFilter(ff, xw);
        pw.flush();
        CharArrayReader car = new CharArrayReader(caw.toCharArray());
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        XMLReader parser = spf.newSAXParser().getXMLReader();
        XMLFilterHandler.FilterHandler handler = this.filterHandler.getStAXContentHandler();
        parser.setContentHandler(new SAX2StAXAdaptor(handler));
        parser.parse(new InputSource(car));
        FeatureFilter rtff = handler.getFeatureFilter();
        FilterXMLTest.assertTrue((String)("Testing that " + ff.toString() + " contains " + rtff.toString()), (boolean)FilterUtils.areProperSubset(rtff, ff));
        FilterXMLTest.assertTrue((String)("Testing that " + rtff.toString() + " contains " + ff.toString()), (boolean)FilterUtils.areProperSubset(ff, rtff));
        return rtff;
    }

    public void testByType() throws Exception {
        this.roundTripFilter(new FeatureFilter.ByType("foo"));
    }

    public void testNot() throws Exception {
        this.roundTripFilter(new FeatureFilter.Not(new FeatureFilter.ByType("bar")));
    }

    public void testAnd() throws Exception {
        this.roundTripFilter(new FeatureFilter.And(new FeatureFilter.ByType("foo"), new FeatureFilter.BySource("bar")));
    }

    public void testMultiAnd() throws Exception {
        this.roundTripFilter(new FeatureFilter.And(new FeatureFilter.And(new FeatureFilter.ByType("foo"), new FeatureFilter.BySource("bar")), new FeatureFilter.ByComponentName("AL121903")));
        this.roundTripFilter(new FeatureFilter.And(new FeatureFilter.ByType("foo"), new FeatureFilter.And(new FeatureFilter.BySource("bar"), new FeatureFilter.ByComponentName("AL121903"))));
    }

    public void testLocation() throws Exception {
        this.roundTripFilter(new FeatureFilter.OverlapsLocation(new RangeLocation(500, 2000)));
        Location complex = LocationTools.union(new RangeLocation(100, 200), new RangeLocation(500, 600));
        this.roundTripFilter(new FeatureFilter.ContainedByLocation(complex));
    }

    public void testHasAnnotation() throws Exception {
        this.roundTripFilter(new FeatureFilter.HasAnnotation("foo"));
    }

    public void testByAnnotation() throws Exception {
        this.roundTripFilter(new FeatureFilter.ByAnnotation("foo", "bar"));
    }

    public void testStrandFilter() throws Exception {
        this.roundTripFilter(new FeatureFilter.StrandFilter(StrandedFeature.POSITIVE));
        this.roundTripFilter(new FeatureFilter.StrandFilter(StrandedFeature.NEGATIVE));
        this.roundTripFilter(new FeatureFilter.StrandFilter(StrandedFeature.UNKNOWN));
    }

    public void testFrameFilter() throws Exception {
        this.roundTripFilter(new FeatureFilter.FrameFilter(FramedFeature.FRAME_1));
    }

    public void testByClass() throws Exception {
        this.roundTripFilter(new FeatureFilter.ByClass(ComponentFeature.class));
    }

    public void testByParent() throws Exception {
        this.roundTripFilter(new FeatureFilter.ByParent(new FeatureFilter.ByType("foo")));
    }

    public void testAnnotationContains() throws Exception {
        this.roundTripFilter(new FeatureFilter.AnnotationContains("foo.bar", "baz"));
    }
}

