/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.game;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.bio.seq.io.game.StAXHandlerFactory;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StAXFeatureHandler
extends StAXContentHandlerBase {
    private boolean setOnceFired = false;
    private String myLocalName;
    private boolean hasCallback = false;
    private List handlers = new ArrayList();
    private boolean startFired = false;
    private boolean endFired = false;
    private boolean inFeature = false;
    protected Feature.Template featureTemplate;
    protected SeqIOListener featureListener;
    protected int startLoc;
    protected int endLoc;
    protected List callbackStack = new ArrayList();
    protected int stackLevel;

    public void setHandlerCharacteristics(String localName, boolean hasCallback) {
        if (!this.setOnceFired) {
            this.myLocalName = localName;
            this.hasCallback = hasCallback;
            this.setOnceFired = true;
        } else {
            System.err.println("setHandlerChracteristics called twice on same handler.");
        }
    }

    public void setFeatureListener(SeqIOListener siol) {
        this.featureListener = siol;
    }

    protected void addHandler(ElementRecognizer rec, StAXHandlerFactory handler) {
        this.handlers.add(new Binding(rec, handler));
    }

    protected Feature.Template createTemplate() {
        Feature.Template ft = new Feature.Template();
        ft.annotation = new SmallAnnotation();
        return ft;
    }

    protected int getLevel() {
        return this.stackLevel;
    }

    protected ListIterator getHandlerStackIterator(int level) {
        return this.callbackStack.listIterator(level);
    }

    protected void push(StAXContentHandler handler) {
        this.callbackStack.add(handler);
        ++this.stackLevel;
    }

    protected void pop() {
        --this.stackLevel;
        this.callbackStack.remove(this.stackLevel);
    }

    public SeqIOListener getFeatureListener() {
        return this.featureListener;
    }

    private void fireStartFeature() throws ParseException {
        if (this.startFired) {
            throw new ParseException("startFeature event has already been fired");
        }
        if (this.featureTemplate == null) {
            this.featureTemplate = this.createTemplate();
        }
        if (this.featureTemplate.annotation == null) {
            this.featureTemplate.annotation = Annotation.EMPTY_ANNOTATION;
        }
        this.featureListener.startFeature(this.featureTemplate);
        this.startFired = true;
    }

    private void fireEndFeature() throws ParseException {
        if (!this.startFired) {
            throw new ParseException("startFeature has not yet been fired!");
        }
        if (this.endFired) {
            throw new ParseException("endFeature event has already been fired!");
        }
        this.featureListener.endFeature();
        this.endFired = true;
    }

    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
    }

    @Override
    public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
        if (!this.setOnceFired) {
            throw new SAXException("StAXFeaturehandler not initialised before use!");
        }
        for (int i = this.handlers.size() - 1; i >= 0; --i) {
            Binding b = (Binding)this.handlers.get(i);
            if (!b.recognizer.filterStartElement(nsURI, localName, qName, attrs)) continue;
            dm.delegate(b.handlerFactory.getHandler(this));
            return;
        }
        if (!this.myLocalName.equals(localName)) {
            return;
        }
        if (!this.inFeature) {
            this.inFeature = true;
            if (this.hasCallback && this.stackLevel == 0) {
                this.push(this);
            }
            try {
                if (!this.startFired) {
                    this.fireStartFeature();
                }
            }
            catch (ParseException pe) {
                throw new SAXException("ParseException thrown in user code");
            }
        }
        this.startElementHandler(nsURI, localName, qName, attrs);
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
    }

    @Override
    public void endElement(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
        if (!this.myLocalName.equals(localName)) {
            return;
        }
        this.endElementHandler(nsURI, localName, qName, handler);
        if (this.hasCallback) {
            this.pop();
        }
        if (this.stackLevel == 0) {
            try {
                if (!this.startFired) {
                    this.fireStartFeature();
                }
                if (!this.endFired) {
                    this.fireEndFeature();
                }
            }
            catch (ParseException pe) {
                throw new SAXException("ParseException thrown in user code");
            }
        }
    }

    class Binding {
        final ElementRecognizer recognizer;
        final StAXHandlerFactory handlerFactory;

        Binding(ElementRecognizer er, StAXHandlerFactory hf) {
            this.recognizer = er;
            this.handlerFactory = hf;
        }
    }
}

