/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.project;

import junit.framework.TestCase;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.projection.ProjectedFeatureHolder;
import org.biojava.bio.seq.projection.ReparentContext;
import org.biojava.bio.seq.projection.TranslateFlipContext;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class ProjectedFeatureHolderTest
extends TestCase {
    public ProjectedFeatureHolderTest(String name) {
        super(name);
    }

    public void testReparentContext() throws Exception {
        SimpleSequence seq = new SimpleSequence(DNATools.createDNA("gattaca"), "test", "test", Annotation.EMPTY_ANNOTATION);
        SimpleSequence seq2 = new SimpleSequence(DNATools.createDNA("-------"), "test", "test", Annotation.EMPTY_ANNOTATION);
        Feature.Template template = new Feature.Template();
        template.type = "test";
        template.source = "foo";
        template.location = new RangeLocation(2, 4);
        template.annotation = Annotation.EMPTY_ANNOTATION;
        Feature origFeat = seq.createFeature(template);
        ProjectedFeatureHolder pfh = new ProjectedFeatureHolder(new ReparentContext(seq2, seq));
        ProjectedFeatureHolderTest.assertEquals((String)"Same size", (int)pfh.countFeatures(), (int)seq.countFeatures());
        Feature projFeat = (Feature)pfh.features().next();
        ProjectedFeatureHolderTest.assertEquals((String)"getSource()", (String)origFeat.getSource(), (String)projFeat.getSource());
        ProjectedFeatureHolderTest.assertEquals((String)"getType()", (String)origFeat.getType(), (String)projFeat.getType());
        ProjectedFeatureHolderTest.assertEquals((String)"getLocation()", (Object)origFeat.getLocation(), (Object)projFeat.getLocation());
        ProjectedFeatureHolderTest.assertEquals((String)"origFeat.getParent()", (Object)origFeat.getParent(), (Object)seq);
        ProjectedFeatureHolderTest.assertEquals((String)"projFeat.getParent()", (Object)projFeat.getParent(), (Object)seq2);
    }

    public void testReparentContext_create() throws Exception {
        SimpleSequence seq = new SimpleSequence(DNATools.createDNA("gattaca"), "test", "test", Annotation.EMPTY_ANNOTATION);
        SimpleSequence seq2 = new SimpleSequence(DNATools.createDNA("-------"), "test", "test", Annotation.EMPTY_ANNOTATION);
        Feature.Template template = new Feature.Template();
        template.type = "test";
        template.source = "foo";
        template.location = new RangeLocation(2, 4);
        template.annotation = Annotation.EMPTY_ANNOTATION;
        ProjectedFeatureHolder pfh = new ProjectedFeatureHolder(new ReparentContext(seq2, seq));
        Feature projFeat = pfh.createFeature(template);
        Feature origFeat = (Feature)seq.features().next();
        ProjectedFeatureHolderTest.assertEquals((String)"Same size", (int)pfh.countFeatures(), (int)seq.countFeatures());
        ProjectedFeatureHolderTest.assertEquals((String)"getSource()", (String)origFeat.getSource(), (String)projFeat.getSource());
        ProjectedFeatureHolderTest.assertEquals((String)"getType()", (String)origFeat.getType(), (String)projFeat.getType());
        ProjectedFeatureHolderTest.assertEquals((String)"getLocation()", (Object)origFeat.getLocation(), (Object)projFeat.getLocation());
        ProjectedFeatureHolderTest.assertEquals((String)"origFeat.getParent()", (Object)origFeat.getParent(), (Object)seq);
        ProjectedFeatureHolderTest.assertEquals((String)"projFeat.getParent()", (Object)projFeat.getParent(), (Object)seq2);
    }

    public void testTranslateFlipContext_translateOnly() throws Exception {
        SimpleSequence seq = new SimpleSequence(DNATools.createDNA("gattaca"), "test", "test", Annotation.EMPTY_ANNOTATION);
        SimpleSequence seq2 = new SimpleSequence(DNATools.createDNA("-------"), "test", "test", Annotation.EMPTY_ANNOTATION);
        StrandedFeature.Template template = new StrandedFeature.Template();
        template.type = "test";
        template.source = "foo";
        template.location = new RangeLocation(2, 4);
        template.annotation = Annotation.EMPTY_ANNOTATION;
        template.strand = StrandedFeature.NEGATIVE;
        StrandedFeature origFeat = (StrandedFeature)seq.createFeature(template);
        ProjectedFeatureHolder pfh = new ProjectedFeatureHolder(new TranslateFlipContext((FeatureHolder)seq2, (FeatureHolder)seq, 3, false));
        ProjectedFeatureHolderTest.assertEquals((String)"Same size", (int)pfh.countFeatures(), (int)seq.countFeatures());
        StrandedFeature projFeat = (StrandedFeature)pfh.features().next();
        ProjectedFeatureHolderTest.assertEquals((String)"getSource()", (String)origFeat.getSource(), (String)projFeat.getSource());
        ProjectedFeatureHolderTest.assertEquals((String)"getType()", (String)origFeat.getType(), (String)projFeat.getType());
        ProjectedFeatureHolderTest.assertEquals((String)"getLocation()", (Object)origFeat.getLocation().translate(3), (Object)projFeat.getLocation());
        ProjectedFeatureHolderTest.assertEquals((String)"getStrand()", (Object)origFeat.getStrand(), (Object)projFeat.getStrand());
        ProjectedFeatureHolderTest.assertEquals((String)"projFeat.getParent()", (Object)projFeat.getParent(), (Object)seq2);
        ProjectedFeatureHolderTest.assertEquals((String)"pfh.filter(5,7).size() == 1", (int)1, (int)pfh.filter(FilterUtils.containedByLocation(projFeat.getLocation())).countFeatures());
        ProjectedFeatureHolderTest.assertTrue((String)"pfh.filter(5,7).contains(projFeat)", (boolean)pfh.filter(FilterUtils.containedByLocation(projFeat.getLocation())).containsFeature(projFeat));
        ProjectedFeatureHolderTest.assertEquals((String)"projFeat.filter(POSITIVE).size() == 1", (int)1, (int)pfh.filter(FilterUtils.byStrand(origFeat.getStrand())).countFeatures());
    }

    public void testTranslateFlipContext_translateAndFlip() throws Exception {
        SimpleSequence seq = new SimpleSequence(DNATools.createDNA("gattaca"), "test", "test", Annotation.EMPTY_ANNOTATION);
        SimpleSequence seq2 = new SimpleSequence(DNATools.createDNA("-------"), "test", "test", Annotation.EMPTY_ANNOTATION);
        StrandedFeature.Template template = new StrandedFeature.Template();
        template.type = "test";
        template.source = "foo";
        template.location = new RangeLocation(2, 3);
        template.annotation = Annotation.EMPTY_ANNOTATION;
        template.strand = StrandedFeature.NEGATIVE;
        StrandedFeature origFeat = (StrandedFeature)seq.createFeature(template);
        ProjectedFeatureHolder pfh = new ProjectedFeatureHolder(new TranslateFlipContext((FeatureHolder)seq2, (FeatureHolder)seq, seq.length() + 1, true));
        ProjectedFeatureHolderTest.assertEquals((String)"Same size", (int)pfh.countFeatures(), (int)seq.countFeatures());
        StrandedFeature projFeat = (StrandedFeature)pfh.features().next();
        ProjectedFeatureHolderTest.assertEquals((String)"getSource()", (String)origFeat.getSource(), (String)projFeat.getSource());
        ProjectedFeatureHolderTest.assertEquals((String)"getType()", (String)origFeat.getType(), (String)projFeat.getType());
        ProjectedFeatureHolderTest.assertEquals((String)"getLocation()", (Object)new RangeLocation(5, 6), (Object)projFeat.getLocation());
        ProjectedFeatureHolderTest.assertEquals((String)"getStrand()", (Object)StrandedFeature.POSITIVE, (Object)projFeat.getStrand());
        ProjectedFeatureHolderTest.assertEquals((String)"projFeat.getParent()", (Object)projFeat.getParent(), (Object)seq2);
        ProjectedFeatureHolderTest.assertEquals((String)"pfh.filter(5,6).size() == 1", (int)1, (int)pfh.filter(FilterUtils.containedByLocation(projFeat.getLocation())).countFeatures());
        ProjectedFeatureHolderTest.assertTrue((String)"pfh.filter(5,6).contains(projFeat)", (boolean)pfh.filter(FilterUtils.containedByLocation(projFeat.getLocation())).containsFeature(projFeat));
        ProjectedFeatureHolderTest.assertEquals((String)"projFeat.filter(NEGATIVE).size() == 0", (int)0, (int)pfh.filter(FilterUtils.byStrand(StrandedFeature.NEGATIVE)).countFeatures());
        ProjectedFeatureHolderTest.assertEquals((String)"projFeat.filter(POSITIVE).size() == 1", (int)1, (int)pfh.filter(FilterUtils.byStrand(StrandedFeature.POSITIVE)).countFeatures());
    }

    public void testTranslateFlipContext_translateAndFlip_create() throws Exception {
        SimpleSequence seq = new SimpleSequence(DNATools.createDNA("gattaca"), "test", "test", Annotation.EMPTY_ANNOTATION);
        SimpleSequence seq2 = new SimpleSequence(DNATools.createDNA("-------"), "test", "test", Annotation.EMPTY_ANNOTATION);
        StrandedFeature.Template template = new StrandedFeature.Template();
        template.type = "test";
        template.source = "foo";
        template.location = new RangeLocation(5, 6);
        template.annotation = Annotation.EMPTY_ANNOTATION;
        template.strand = StrandedFeature.POSITIVE;
        ProjectedFeatureHolder pfh = new ProjectedFeatureHolder(new TranslateFlipContext((FeatureHolder)seq2, (FeatureHolder)seq, seq.length() + 1, true));
        StrandedFeature projFeat = (StrandedFeature)pfh.createFeature(template);
        StrandedFeature origFeat = (StrandedFeature)seq.features().next();
        ProjectedFeatureHolderTest.assertEquals((String)"Same size", (int)pfh.countFeatures(), (int)seq.countFeatures());
        ProjectedFeatureHolderTest.assertEquals((String)"getSource()", (String)origFeat.getSource(), (String)projFeat.getSource());
        ProjectedFeatureHolderTest.assertEquals((String)"getType()", (String)origFeat.getType(), (String)projFeat.getType());
        ProjectedFeatureHolderTest.assertEquals((String)"getLocation()", (Object)new RangeLocation(5, 6), (Object)projFeat.getLocation());
        ProjectedFeatureHolderTest.assertEquals((String)"getStrand()", (Object)StrandedFeature.POSITIVE, (Object)projFeat.getStrand());
        ProjectedFeatureHolderTest.assertEquals((String)"projFeat.getParent()", (Object)projFeat.getParent(), (Object)seq2);
        ProjectedFeatureHolderTest.assertEquals((String)"pfh.filter(5,6).size() == 1", (int)1, (int)pfh.filter(FilterUtils.containedByLocation(projFeat.getLocation())).countFeatures());
        ProjectedFeatureHolderTest.assertTrue((String)"pfh.filter(5,6).contains(projFeat)", (boolean)pfh.filter(FilterUtils.containedByLocation(projFeat.getLocation())).containsFeature(projFeat));
        ProjectedFeatureHolderTest.assertEquals((String)"projFeat.filter(NEGATIVE).size() == 0", (int)0, (int)pfh.filter(FilterUtils.byStrand(StrandedFeature.NEGATIVE)).countFeatures());
        ProjectedFeatureHolderTest.assertEquals((String)"projFeat.filter(POSITIVE).size() == 1", (int)1, (int)pfh.filter(FilterUtils.byStrand(StrandedFeature.POSITIVE)).countFeatures());
    }

    public void testFeatureChangeEvent() throws Exception {
        SimpleSequence seq = new SimpleSequence(DNATools.createDNA("gattaca"), "test", "test", Annotation.EMPTY_ANNOTATION);
        Feature.Template template = new Feature.Template();
        template.type = "test";
        template.source = "foo";
        template.location = new RangeLocation(2, 4);
        template.annotation = Annotation.EMPTY_ANNOTATION;
        Feature seqFeature = seq.createFeature(template);
        ProjectedFeatureHolder pfh = new ProjectedFeatureHolder(new TranslateFlipContext((FeatureHolder)seq, (FeatureHolder)seq, 7, true));
        Feature pfhFeature = (Feature)pfh.filter(new FeatureFilter.ByType("test")).features().next();
        pfhFeature.addChangeListener(ChangeListener.ALWAYS_VETO, ChangeType.UNKNOWN);
        boolean vetoed = false;
        try {
            seqFeature.setLocation(new RangeLocation(1, 3));
        }
        catch (ChangeVetoException cve) {
            vetoed = true;
        }
        ProjectedFeatureHolderTest.assertTrue((boolean)vetoed);
        pfhFeature.removeChangeListener(ChangeListener.ALWAYS_VETO, ChangeType.UNKNOWN);
        seqFeature.setLocation(new RangeLocation(1, 3));
    }
}

