/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.HetatomImpl;
import org.biojava.bio.structure.io.PDBParseException;

public class NucleotideImpl
extends HetatomImpl
implements Group {
    public static final String type = "nucleotide";

    @Override
    public String getType() {
        return type;
    }

    @Override
    public String toString() {
        String str = "PDB: " + this.pdb_name + " " + this.pdb_code + " " + this.pdb_flag;
        if (this.pdb_flag) {
            str = str + "atoms: " + this.atoms.size();
        }
        return str;
    }

    @Override
    public Object clone() {
        NucleotideImpl n = new NucleotideImpl();
        n.setPDBFlag(this.has3D());
        n.setPDBCode(this.getPDBCode());
        try {
            n.setPDBName(this.getPDBName());
        }
        catch (PDBParseException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom = (Atom)this.atoms.get(i);
            n.addAtom((Atom)atom.clone());
        }
        return n;
    }
}

