/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Map;
import junit.framework.TestCase;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.io.PDBFileParser;

public class PDBFileParserTest
extends TestCase {
    PDBFileParser parser;

    protected void setUp() {
        this.parser = new PDBFileParser();
    }

    private Object testREMARKParsing(String fakeFile) throws Exception {
        BufferedReader br = new BufferedReader(new StringReader(fakeFile));
        Object resolution = null;
        Structure s = this.parser.parsePDBFile(br);
        Map<String, Object> m = s.getHeader();
        resolution = m.get("resolution");
        return resolution;
    }

    public void testREMARK200() {
        String w1 = "REMARK 200  RESOLUTION RANGE HIGH      (A) : 1.20\nREMARK 200  RESOLUTION RANGE LOW       (A) : 20.00REMARK   200 RESOLUTION9.9  ANGSTROMS.";
        boolean parsingOK = true;
        String errorMsg = "";
        try {
            Object resolution = this.testREMARKParsing(w1);
            PDBFileParserTest.assertEquals((Object)resolution, null);
        }
        catch (Exception e) {
            parsingOK = false;
            errorMsg = e.getMessage();
        }
        PDBFileParserTest.assertEquals((String)("parsing failed with error " + errorMsg), (boolean)parsingOK, (boolean)true);
    }

    public void testREMARK2() {
        String w2 = "REMARK   2 \nREMARK   2 RESOLUTION. 1.2  ANGSTROMS.";
        boolean parsingOK = true;
        String errorMsg = "";
        try {
            Object resolution = this.testREMARKParsing(w2);
            PDBFileParserTest.assertEquals((Object)resolution, (Object)new Float(1.2));
        }
        catch (Exception e) {
            parsingOK = false;
            errorMsg = e.getMessage();
        }
        PDBFileParserTest.assertEquals((String)("parsing failed with error " + errorMsg), (boolean)parsingOK, (boolean)true);
    }
}

