/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import junit.framework.TestCase;
import org.biojava.bio.structure.Compound;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.GroupIterator;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.io.PDBFileParser;

public class PdbFileFormat30Test
extends TestCase {
    protected void setUp() {
    }

    public void testRead30File() {
        Structure s = this.getStructure("/files/388d_v30.pdb");
        int nrNuc = this.getNrNucleotides(s);
        int shouldNr = 20;
        PdbFileFormat30Test.assertEquals((String)"structure does not contain the right number of nucleotides ", (int)shouldNr, (int)nrNuc);
        Structure s2 = this.getStructure("/files/104D_v30.pdb");
        int nrNuc2 = this.getNrNucleotides(s2);
        int shouldNr2 = 24;
        PdbFileFormat30Test.assertEquals((String)"structure does not contain the right number of nucleotides ", (int)shouldNr2, (int)nrNuc2);
        List<Compound> compounds = s.getCompounds();
        PdbFileFormat30Test.assertTrue((compounds.size() == 1 ? 1 : 0) != 0);
        Compound mol = compounds.get(0);
        PdbFileFormat30Test.assertTrue((boolean)mol.getMolName().startsWith("DNA"));
    }

    public void testRead23File() {
        Structure s = this.getStructure("/files/388d_v23.pdb");
        int nrNuc = this.getNrNucleotides(s);
        int shouldNr = 24;
        PdbFileFormat30Test.assertEquals((String)"structure does not contain the right number of nucleotides ", (int)shouldNr, (int)nrNuc);
        Structure s2 = this.getStructure("/files/104D_v23.pdb");
        int nrNuc2 = this.getNrNucleotides(s2);
        int shouldNr2 = 24;
        PdbFileFormat30Test.assertEquals((String)"structure does not contain the right number of nucleotides ", (int)shouldNr2, (int)nrNuc2);
        List<Compound> compounds = s.getCompounds();
        PdbFileFormat30Test.assertTrue((compounds.size() == 1 ? 1 : 0) != 0);
        Compound mol = compounds.get(0);
        PdbFileFormat30Test.assertTrue((boolean)mol.getMolName().startsWith("DNA"));
    }

    private Structure getStructure(String fileName) {
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
        PdbFileFormat30Test.assertNotNull((Object)inStream);
        PDBFileParser pdbpars = new PDBFileParser();
        Structure structure = null;
        try {
            structure = pdbpars.parsePDBFile(inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return structure;
    }

    private int getNrNucleotides(Structure s) {
        GroupIterator iter = new GroupIterator(s);
        int nr = 0;
        while (iter.hasNext()) {
            Group g = iter.next();
            if (!g.getType().equals("nucleotide")) continue;
            ++nr;
        }
        return nr;
    }
}

