/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.biojava.bio.structure.Compound;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.io.PDBFileParser;

public class SourceCompoundTest
extends TestCase {
    private Structure getStructure(String fileName) {
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
        SourceCompoundTest.assertNotNull((Object)inStream);
        PDBFileParser pdbpars = new PDBFileParser();
        Structure structure = null;
        try {
            structure = pdbpars.parsePDBFile(inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return structure;
    }

    public void testCompoundSourceStructure() {
        Structure s2 = this.getStructure("/files/2gox.pdb");
        SourceCompoundTest.assertEquals((int)2, (int)s2.getCompounds().size());
        for (Compound compound : s2.getCompounds()) {
            if (compound.getMolId().equals("1")) {
                SourceCompoundTest.assertEquals((String)"COMPLEMENT C3", (String)compound.getMolName());
                SourceCompoundTest.assertEquals((String)"[A, C]", (String)compound.getChainId().toString());
                SourceCompoundTest.assertEquals((String)"FRAGMENT OF ALPHA CHAIN: RESIDUES 996-1287", (String)compound.getFragment());
                SourceCompoundTest.assertEquals((String)"YES", (String)compound.getEngineered());
                SourceCompoundTest.assertEquals((String)"YES", (String)compound.getMutation());
                SourceCompoundTest.assertEquals((String)"HOMO SAPIENS", (String)compound.getOrganismScientific());
                SourceCompoundTest.assertEquals((String)"HUMAN", (String)compound.getOrganismCommon());
                SourceCompoundTest.assertEquals((String)"C3", (String)compound.getGene());
                SourceCompoundTest.assertEquals((String)"ESCHERICHIA COLI", (String)compound.getExpressionSystem());
                SourceCompoundTest.assertEquals((String)"BL21(DE3)", (String)compound.getExpressionSystemStrain());
                SourceCompoundTest.assertEquals((String)"PLASMID", (String)compound.getExpressionSystemVectorType());
                SourceCompoundTest.assertEquals((String)"PT7-", (String)compound.getExpressionSystemPlasmid());
            }
            if (!compound.getMolId().equals("2")) continue;
            SourceCompoundTest.assertEquals((String)"FIBRINOGEN-BINDING PROTEIN", (String)compound.getMolName());
            SourceCompoundTest.assertEquals((String)"[B, D]", (String)compound.getChainId().toString());
            SourceCompoundTest.assertEquals((String)"C-TERMINAL DOMAIN: RESIDUES 101-165", (String)compound.getFragment());
            SourceCompoundTest.assertEquals((String)"YES", (String)compound.getEngineered());
            SourceCompoundTest.assertEquals((String)"STAPHYLOCOCCUS AUREUS", (String)compound.getOrganismScientific());
            SourceCompoundTest.assertEquals((String)"BACTERIA", (String)compound.getOrganismCommon());
            SourceCompoundTest.assertEquals((String)"MU50 / ATCC 700699", (String)compound.getStrain());
            SourceCompoundTest.assertEquals((String)"EFB", (String)compound.getGene());
            SourceCompoundTest.assertEquals((String)"ESCHERICHIA COLI", (String)compound.getExpressionSystem());
            SourceCompoundTest.assertEquals((String)"BL21(DE3)", (String)compound.getExpressionSystemStrain());
            SourceCompoundTest.assertEquals((String)"PLASMID", (String)compound.getExpressionSystemVectorType());
            SourceCompoundTest.assertEquals((String)"PT7HMT", (String)compound.getExpressionSystemPlasmid());
        }
    }

    public void testCOMPNDsectionFRAGMENT() {
        Structure s2 = this.getStructure("/files/2gox.pdb");
        Structure s4 = this.getStructure("/files/3cfy.pdb");
        for (Compound compound : s2.getCompounds()) {
            if (!compound.getMolId().equals("1")) continue;
            SourceCompoundTest.assertEquals((String)"FRAGMENT OF ALPHA CHAIN: RESIDUES 996-1287", (String)compound.getFragment());
        }
        for (Compound compound : s4.getCompounds()) {
            if (!compound.getMolId().equals("1")) continue;
            SourceCompoundTest.assertEquals((String)"SIGNAL RECEIVER DOMAIN: RESIDUES 2-128", (String)compound.getFragment());
        }
    }

    public void testCOMPNDsectionCHAINS() {
        Structure s3 = this.getStructure("/files/2pos.pdb");
        SourceCompoundTest.assertEquals((int)1, (int)s3.getCompounds().size());
        for (Compound compound : s3.getCompounds()) {
            System.out.println(compound.getMolId());
            System.out.println(compound.getMolName());
            System.out.println(compound.getChainId().toString());
            System.out.println(compound.getOrganismScientific());
            System.out.println(compound.getStrain());
            SourceCompoundTest.assertEquals((String)"1", (String)compound.getMolId());
            SourceCompoundTest.assertEquals((String)"SYLVATICIN", (String)compound.getMolName());
            SourceCompoundTest.assertEquals((String)"[A, B, C, D]", (String)compound.getChainId().toString());
            SourceCompoundTest.assertEquals((String)"PYTHIUM SYLVATICUM", (String)compound.getOrganismScientific());
            SourceCompoundTest.assertEquals((String)"STRAIN 37", (String)compound.getStrain());
        }
    }

    public void testSOURCEsectionSTRAIN() {
        Structure s4 = this.getStructure("/files/3cfy.pdb");
        for (Compound compound : s4.getCompounds()) {
            if (!compound.getMolId().equals("1")) continue;
            System.out.println(compound.getMolId());
            System.out.println(compound.getMolName());
            System.out.println(compound.getChainId().toString());
            System.out.println(compound.getFragment());
            System.out.println(compound.getEngineered());
            System.out.println(compound.getOrganismScientific());
            System.out.println(compound.getOrganismCommon());
            System.out.println(compound.getStrain());
            System.out.println(compound.getGene());
            System.out.println(compound.getExpressionSystem());
            System.out.println(compound.getExpressionSystemVectorType());
            System.out.println(compound.getExpressionSystemVector());
            System.out.println(compound.getExpressionSystemPlasmid());
            SourceCompoundTest.assertEquals((String)"1", (String)compound.getMolId());
            SourceCompoundTest.assertEquals((String)"PUTATIVE LUXO REPRESSOR PROTEIN", (String)compound.getMolName());
            SourceCompoundTest.assertEquals((String)"[A]", (String)compound.getChainId().toString());
            SourceCompoundTest.assertEquals((String)"SIGNAL RECEIVER DOMAIN: RESIDUES 2-128", (String)compound.getFragment());
            SourceCompoundTest.assertEquals((String)"YES", (String)compound.getEngineered());
            SourceCompoundTest.assertEquals((String)"VIBRIO PARAHAEMOLYTICUS RIMD 2210633", (String)compound.getOrganismScientific());
            SourceCompoundTest.assertEquals((String)"BACTERIA", (String)compound.getOrganismCommon());
            SourceCompoundTest.assertEquals((String)"RIMD 2210633 / SEROTYPE O3:K6", (String)compound.getStrain());
            SourceCompoundTest.assertEquals((String)"VP1469", (String)compound.getGene());
            SourceCompoundTest.assertEquals((String)"ESCHERICHIA COLI", (String)compound.getExpressionSystem());
            SourceCompoundTest.assertEquals((String)"PLASMID", (String)compound.getExpressionSystemVectorType());
            SourceCompoundTest.assertEquals((String)"PET", (String)compound.getExpressionSystemVector());
            SourceCompoundTest.assertEquals((String)"BC-PSGX3(BC)", (String)compound.getExpressionSystemPlasmid());
        }
    }

    public void testSOURCEsectionORGSCI() {
        Structure s5 = this.getStructure("/files/3cdl.pdb");
        for (Compound compound : s5.getCompounds()) {
            if (!compound.getMolId().equals("1")) continue;
            System.out.println(compound.getOrganismScientific());
            SourceCompoundTest.assertEquals((String)"PSEUDOMONAS SYRINGAE PV. TOMATO STR. DC3000", (String)compound.getOrganismScientific());
        }
    }
}

