/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.align.StructurePairAligner;
import org.biojava.bio.structure.align.pairwise.AlternativeAlignment;
import org.biojava.bio.structure.io.PDBFileParser;

public class StructurePairAlignerTest
extends TestCase {
    Structure structure1;
    Structure structure2;

    protected void setUp() {
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream("/files/5pti.pdb");
        StructurePairAlignerTest.assertNotNull((Object)inStream);
        InputStream inStream2 = ((Object)((Object)this)).getClass().getResourceAsStream("/files/1tap.pdb");
        StructurePairAlignerTest.assertNotNull((Object)inStream2);
        PDBFileParser pdbpars = new PDBFileParser();
        try {
            this.structure1 = pdbpars.parsePDBFile(inStream);
            this.structure2 = pdbpars.parsePDBFile(inStream2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StructurePairAlignerTest.assertNotNull((Object)this.structure1);
        StructurePairAlignerTest.assertNotNull((Object)this.structure2);
        StructurePairAlignerTest.assertEquals((String)"structure does not contain one chain ", (int)1, (int)this.structure1.size());
    }

    public void testAlignStructureStructure() {
        StructurePairAligner aligner = new StructurePairAligner();
        boolean allFine = true;
        String msg = "";
        try {
            aligner.align(this.structure1, this.structure2);
            AlternativeAlignment[] aligs = aligner.getAlignments();
            StructurePairAlignerTest.assertEquals((String)"the number of obtained alternative alignments is not correct", (int)20, (int)aligs.length);
            AlternativeAlignment a = aligs[0];
            StructurePairAlignerTest.assertEquals((String)"the expected nr of eq. residues is not correct.", (int)48, (int)a.getEqr());
            StructurePairAlignerTest.assertTrue((a.getRmsd() < 3.0 ? 1 : 0) != 0);
            StructurePairAlignerTest.assertTrue((a.getRmsd() > 2.0 ? 1 : 0) != 0);
            StructurePairAlignerTest.assertTrue((a.getPercId() > 9 ? 1 : 0) != 0);
            StructurePairAlignerTest.assertTrue((a.getScore() > 150.0f ? 1 : 0) != 0);
        }
        catch (Exception e) {
            msg = e.getMessage();
            allFine = false;
        }
        StructurePairAlignerTest.assertTrue((boolean)allFine);
        StructurePairAlignerTest.assertEquals((String)"an error occured", (String)"", (String)msg);
    }
}

