/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Calc;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Compound;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.PDBHeader;
import org.biojava.bio.structure.SSBond;
import org.biojava.bio.structure.SVDSuperimposer;
import org.biojava.bio.structure.StandardAminoAcid;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.io.PDBFileParser;
import org.biojava.bio.structure.jama.Matrix;

public class StructureTest
extends TestCase {
    Structure structure;

    protected void setUp() {
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream("/files/5pti.pdb");
        StructureTest.assertNotNull((Object)inStream);
        PDBFileParser pdbpars = new PDBFileParser();
        try {
            this.structure = pdbpars.parsePDBFile(inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StructureTest.assertNotNull((Object)this.structure);
        StructureTest.assertEquals((String)"structure does not contain one chain ", (int)1, (int)this.structure.size());
    }

    public void testSeqResParsing() {
        List<Chain> chains = this.structure.getChains(0);
        StructureTest.assertEquals((String)" nr of found chains not correct!", (int)1, (int)chains.size());
        Chain c = chains.get(0);
        List<Group> seqResGroups = c.getSeqResGroups();
        StructureTest.assertEquals((String)"nr of SEQRES groups not correct!", (int)58, (int)seqResGroups.size());
        List<Group> atomGroups = c.getAtomGroups();
        Group g3 = seqResGroups.get(2);
        int indexAtom = atomGroups.indexOf(g3);
        StructureTest.assertEquals((String)"the SEQRES group can not be found in the ATOM list", (int)2, (int)indexAtom);
        Group g5 = atomGroups.get(5);
        StructureTest.assertEquals((String)"The ATOM group can not be fond in the SEQRES list", (int)5, (int)seqResGroups.indexOf(g5));
        Group g58 = atomGroups.get(58);
        StructureTest.assertEquals((String)"The group is not PO4", (String)"PO4", (String)g58.getPDBName());
        StructureTest.assertEquals((String)"The group P04 should not be in the SEQRES list", (int)-1, (int)seqResGroups.indexOf(g58));
    }

    public void testReadPDBFile() throws Exception {
        StructureTest.assertEquals((String)"pdb code not set!", (String)"5PTI", (String)this.structure.getPDBCode());
        Chain c = this.structure.getChain(0);
        StructureTest.assertEquals((String)"did not find the expected 58 amino acids!", (int)58, (int)c.getAtomGroups("amino").size());
        StructureTest.assertTrue((c.getAtomGroups("hetatm").size() == 65 ? 1 : 0) != 0);
        StructureTest.assertTrue((c.getAtomGroups("nucleotide").size() == 0 ? 1 : 0) != 0);
        List<Compound> compounds = this.structure.getCompounds();
        StructureTest.assertTrue((compounds.size() == 1 ? 1 : 0) != 0);
        Compound mol = compounds.get(0);
        StructureTest.assertTrue((boolean)mol.getMolName().startsWith("TRYPSIN INHIBITOR"));
    }

    public void testSSBondParsing() throws Exception {
        StructureTest.assertNotNull((Object)this.structure);
        List<SSBond> ssbonds = this.structure.getSSBonds();
        StructureTest.assertEquals((String)"did not find the correct nr of SSBonds ", (int)3, (int)ssbonds.size());
        String pdb1 = "SSBOND   1 CYS      5    CYS     55";
        String pdb2 = "SSBOND   2 CYS     14    CYS     38";
        SSBond bond1 = ssbonds.get(0);
        String b1 = bond1.toPDB();
        StructureTest.assertTrue((String)"PDB representation incorrect", (boolean)pdb1.equals(b1.trim()));
        StructureTest.assertTrue((String)"not right resnum1 ", (boolean)bond1.getResnum1().equals("5"));
        StructureTest.assertTrue((String)"not right resnum2 ", (boolean)bond1.getResnum2().equals("55"));
        SSBond bond2 = ssbonds.get(1);
        String b2 = bond2.toPDB();
        StructureTest.assertTrue((String)"not right resnum1 ", (boolean)bond2.getResnum1().equals("14"));
        StructureTest.assertTrue((String)"not right resnum2 ", (boolean)bond2.getResnum2().equals("38"));
        StructureTest.assertTrue((String)"PDB representation incorrect", (boolean)pdb2.equals(b2.trim()));
    }

    public void testStandardAmino() throws Exception {
        AminoAcid arg = StandardAminoAcid.getAminoAcid("ARG");
        StructureTest.assertTrue((arg.size() == 11 ? 1 : 0) != 0);
        AminoAcid gly = StandardAminoAcid.getAminoAcid("G");
        StructureTest.assertTrue((gly.size() == 4 ? 1 : 0) != 0);
    }

    public void testHeader() {
        Map<String, Object> m = this.structure.getHeader();
        StructureTest.assertNotNull(m);
        String classification = (String)m.get("classification");
        StructureTest.assertTrue((boolean)classification.equals("PROTEINASE INHIBITOR (TRYPSIN)"));
        String idCode = (String)m.get("idCode");
        StructureTest.assertEquals((String)("the idCode in the Header is " + idCode + " and not 5PTI, as expected"), (String)"5PTI", (String)idCode);
        Float resolution = (Float)m.get("resolution");
        StructureTest.assertEquals((String)("the resolution in the Header is " + resolution + " and not 1.8, as expected"), (Object)new Float(1.8), (Object)resolution);
        String technique = (String)m.get("technique");
        String techShould = "NEUTRON DIFFRACTION, X-RAY DIFFRACTION ";
        StructureTest.assertEquals((String)("the technique in the Header is " + technique), (String)techShould, (String)technique);
        List<Compound> compounds = this.structure.getCompounds();
        StructureTest.assertEquals((String)"did not find the right number of compounds! ", (int)1, (int)compounds.size());
        Compound comp = compounds.get(0);
        StructureTest.assertEquals((String)"did not get the right compounds info", (boolean)true, (boolean)comp.getMolName().startsWith("TRYPSIN INHIBITOR"));
        List<String> chainIds = comp.getChainId();
        List<Chain> chains = comp.getChains();
        StructureTest.assertEquals((String)"the number of chain ids and chains did not match!", (int)chainIds.size(), (int)chains.size());
        StructureTest.assertEquals((String)"the chain ID did not match", (String)chainIds.get(0), (String)chains.get(0).getName());
    }

    public void testPDBHeader() {
        Map<String, Object> m = this.structure.getHeader();
        PDBHeader header = this.structure.getPDBHeader();
        String classification = (String)m.get("classification");
        StructureTest.assertTrue((boolean)classification.equals(header.getClassification()));
        String idCode = (String)m.get("idCode");
        StructureTest.assertTrue((boolean)idCode.equals(header.getIdCode()));
        Float resolution = (Float)m.get("resolution");
        StructureTest.assertTrue((resolution.floatValue() == header.getResolution() ? 1 : 0) != 0);
        String technique = (String)m.get("technique");
        StructureTest.assertTrue((boolean)technique.equals(header.getTechnique()));
    }

    public void testCreateVirtualCBAtom() {
        Group g1 = this.structure.getChain(0).getAtomGroup(11);
        if (g1.getPDBName().equals("GLY")) {
            if (g1 instanceof AminoAcid) {
                try {
                    Atom cb = Calc.createVirtualCBAtom((AminoAcid)g1);
                    g1.addAtom(cb);
                }
                catch (StructureException e) {
                    StructureTest.fail((String)("createVirtualCBAtom failed with " + e.getMessage()));
                }
            }
        } else {
            StructureTest.fail((String)"the group at position 11 is not a GLY!");
        }
    }

    public void testMutation() throws Exception {
        Group g1 = (Group)this.structure.getChain(0).getAtomGroup(21).clone();
        StructureTest.assertTrue((g1 != null ? 1 : 0) != 0);
        Group g2 = (Group)this.structure.getChain(0).getAtomGroup(53).clone();
        StructureTest.assertTrue((g2 != null ? 1 : 0) != 0);
        StructureTest.assertEquals((String)"The group at position 22 is not a PHE", (String)"PHE", (String)g1.getPDBName());
        StructureTest.assertEquals((String)"The group position is  not number 22", (String)"22", (String)g1.getPDBCode());
        StructureTest.assertEquals((String)"The group at position 54 is not a THR", (String)"THR", (String)g2.getPDBName());
        StructureTest.assertEquals((String)"The group position is not number 54", (String)"54", (String)g2.getPDBCode());
        Atom[] atoms1 = new Atom[3];
        Atom[] atoms2 = new Atom[3];
        atoms1[0] = g1.getAtom("N");
        atoms1[1] = g1.getAtom("CA");
        atoms1[2] = g1.getAtom("CB");
        atoms2[0] = g2.getAtom("N");
        atoms2[1] = g2.getAtom("CA");
        atoms2[2] = g2.getAtom("CB");
        SVDSuperimposer svds = new SVDSuperimposer(atoms1, atoms2);
        Matrix rotMatrix = svds.getRotation();
        Atom tran = svds.getTranslation();
        Group newGroup = (Group)g2.clone();
        Calc.rotate(newGroup, rotMatrix);
        Calc.shift(newGroup, tran);
        Atom ca1 = g1.getAtom("CA");
        Atom oldca2 = g2.getAtom("CA");
        Atom newca2 = newGroup.getAtom("CA");
        double olddistance = Calc.getDistance(ca1, oldca2);
        StructureTest.assertTrue((olddistance > 10.0 ? 1 : 0) != 0);
        double newdistance = Calc.getDistance(ca1, newca2);
        StructureTest.assertTrue((newdistance < 0.1 ? 1 : 0) != 0);
    }
}

