/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.io.PDBFileParser;

public class StructureToolsTest
extends TestCase {
    Structure structure;

    protected void setUp() {
        InputStream inStream = ((Object)((Object)this)).getClass().getResourceAsStream("/files/5pti.pdb");
        StructureToolsTest.assertNotNull((Object)inStream);
        PDBFileParser pdbpars = new PDBFileParser();
        try {
            this.structure = pdbpars.parsePDBFile(inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StructureToolsTest.assertNotNull((Object)this.structure);
        StructureToolsTest.assertEquals((String)"structure does not contain one chain ", (int)1, (int)this.structure.size());
    }

    public void testGetCAAtoms() {
        Atom[] cas = StructureTools.getAtomCAArray(this.structure);
        StructureToolsTest.assertEquals((String)("did not find the expected number of Atoms (58), but got " + cas.length), (int)58, (int)cas.length);
    }

    public void testGetNrAtoms() {
        int length = StructureTools.getNrAtoms(this.structure);
        StructureToolsTest.assertEquals((String)("did not find the expected number of Atoms (1104), but got " + length), (int)1104, (int)length);
    }
}

