/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.biojava.bio.structure.gui.BiojavaJmol;

public class RasmolCommandListener
extends KeyAdapter
implements ActionListener,
MouseListener {
    JTextField textfield;
    BiojavaJmol.JmolPanel jmolPanel;
    List<String> history;
    int historyPosition;

    public RasmolCommandListener(BiojavaJmol.JmolPanel panel, JTextField field) {
        this.textfield = field;
        this.jmolPanel = panel;
        this.history = new ArrayList<String>();
        this.historyPosition = -2;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String cmd = this.textfield.getText();
        this.jmolPanel.executeCmd(cmd);
        this.textfield.setText("");
        if (cmd.equals("")) {
            return;
        }
        if (this.history.size() > 0) {
            String txt = this.history.get(this.history.size() - 1);
            if (!txt.equals(cmd)) {
                this.history.add(cmd);
            }
        } else {
            this.history.add(cmd);
        }
        this.historyPosition = this.history.size();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String cmd = this.textfield.getText();
        if (cmd.equals("enter RASMOL like command...")) {
            this.textfield.setText("");
            this.textfield.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void keyReleased(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 38 || code == 224) {
            if (this.historyPosition > 0) {
                --this.historyPosition;
            }
        } else if (code == 40 || code == 225) {
            if (this.historyPosition >= this.history.size() - 1) {
                this.textfield.setText("");
                this.historyPosition = this.history.size();
                return;
            }
            ++this.historyPosition;
        } else if (code == 33) {
            if (this.historyPosition > 0) {
                this.historyPosition = 0;
            }
        } else {
            if (code != 34) {
                return;
            }
            if (this.historyPosition >= 0) {
                this.historyPosition = this.history.size() - 1;
            }
        }
        if (this.historyPosition >= 0) {
            String txt = this.history.get(this.historyPosition);
            this.textfield.setText(txt);
        }
    }
}

