/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.AminoAcidImpl;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.ChainImpl;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.io.PDBParseException;

public class CAConverter {
    public static List<Chain> getCAOnly(List<Chain> chains) {
        ArrayList<Chain> newChains = new ArrayList<Chain>();
        for (Chain chain : chains) {
            Chain newChain = CAConverter.getCAOnly(chain);
            newChains.add(newChain);
        }
        return newChains;
    }

    public static Chain getCAOnly(Chain chain) {
        ChainImpl newChain = new ChainImpl();
        newChain.setName(chain.getName());
        newChain.setHeader(chain.getHeader());
        newChain.setSwissprotId(chain.getSwissprotId());
        List<Group> groups = chain.getAtomGroups();
        block2: for (Group g : groups) {
            List<Atom> atoms = g.getAtoms();
            if (!(g instanceof AminoAcid)) continue;
            for (Atom a : atoms) {
                if (!a.getFullName().equals(" CA ")) continue;
                AminoAcidImpl n = new AminoAcidImpl();
                try {
                    n.setPDBName(g.getPDBName());
                }
                catch (PDBParseException e) {
                    e.printStackTrace();
                }
                n.setPDBCode(g.getPDBCode());
                n.addAtom(a);
                newChain.addGroup(n);
                continue block2;
            }
        }
        return newChain;
    }
}

