/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.GroupIterator;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.io.PDBFileParser;
import org.biojava.bio.structure.io.StructureIOFile;
import org.biojava.utils.io.InputStreamProvider;

public class PDBFileReader
implements StructureIOFile {
    String path = "";
    List<String> extensions = new ArrayList<String>();
    boolean parseSecStruc;
    boolean autoFetch;
    boolean parseCAOnly;
    boolean alignSeqRes;

    public static void main(String[] args) {
        String filename = "/path/to/PDBFile.pdb";
        PDBFileReader pdbreader = new PDBFileReader();
        pdbreader.setParseSecStruc(true);
        pdbreader.setAlignSeqRes(true);
        pdbreader.setParseCAOnly(false);
        pdbreader.setAutoFetch(true);
        try {
            Structure struc = pdbreader.getStructure(filename);
            System.out.println(struc);
            GroupIterator gi = new GroupIterator(struc);
            while (gi.hasNext()) {
                Group g = gi.next();
                Chain c = g.getParent();
                if (!(g instanceof AminoAcid)) continue;
                AminoAcid aa = (AminoAcid)g;
                Map<String, String> sec = aa.getSecStruc();
                System.out.println(c.getName() + " " + g + " " + sec);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PDBFileReader() {
        this.extensions.add(".ent");
        this.extensions.add(".pdb");
        this.extensions.add(".ent.gz");
        this.extensions.add(".pdb.gz");
        this.extensions.add(".ent.Z");
        this.extensions.add(".pdb.Z");
        this.parseSecStruc = false;
        this.autoFetch = false;
        this.parseCAOnly = false;
        this.alignSeqRes = true;
    }

    public boolean isParseCAOnly() {
        return this.parseCAOnly;
    }

    public void setParseCAOnly(boolean parseCAOnly) {
        this.parseCAOnly = parseCAOnly;
    }

    public boolean isAlignSeqRes() {
        return this.alignSeqRes;
    }

    public void setAlignSeqRes(boolean alignSeqRes) {
        this.alignSeqRes = alignSeqRes;
    }

    public boolean isAutoFetch() {
        return this.autoFetch;
    }

    public void setAutoFetch(boolean autoFetch) {
        this.autoFetch = autoFetch;
    }

    public boolean isParseSecStruc() {
        return this.parseSecStruc;
    }

    public void setParseSecStruc(boolean parseSecStruc) {
        this.parseSecStruc = parseSecStruc;
    }

    @Override
    public void setPath(String p) {
        this.path = p;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public void addExtension(String s) {
        this.extensions.add(s);
    }

    private InputStream getInputStream(String pdbId) throws IOException {
        InputStream inputStream = null;
        String pdbFile = null;
        File f = null;
        String fpath = this.path + "/" + pdbId;
        String ppath = this.path + "/pdb" + pdbId;
        String[] paths = new String[]{fpath, ppath};
        block0: for (int p = 0; p < paths.length; ++p) {
            String testpath = paths[p];
            for (int i = 0; i < this.extensions.size(); ++i) {
                String ex = this.extensions.get(i);
                f = new File(testpath + ex);
                if (f.exists()) {
                    pdbFile = testpath + ex;
                    InputStreamProvider isp = new InputStreamProvider();
                    inputStream = isp.getInputStream(pdbFile);
                    continue block0;
                }
                if (pdbFile != null) continue block0;
            }
        }
        if (pdbFile == null) {
            if (this.autoFetch) {
                return this.downloadAndGetInputStream(pdbId);
            }
            String message = "no structure with PDB code " + pdbId + " found!";
            throw new IOException(message);
        }
        return inputStream;
    }

    private File downloadPDB(String pdbId) {
        File tempFile = new File(this.path + "/" + pdbId + ".pdb.gz");
        File pdbHome = new File(this.path);
        if (!pdbHome.canWrite()) {
            System.err.println("can not write to " + pdbHome);
            return null;
        }
        String ftp = String.format("ftp://ftp.ebi.ac.uk/pub/databases/msd/pdb_uncompressed/pdb%s.ent", pdbId.toLowerCase());
        System.out.println("Fetching " + ftp);
        try {
            String line;
            URL url = new URL(ftp);
            InputStream conn = url.openStream();
            System.out.println("writing to " + tempFile);
            FileOutputStream outPut = new FileOutputStream(tempFile);
            GZIPOutputStream gzOutPut = new GZIPOutputStream(outPut);
            PrintWriter pw = new PrintWriter(gzOutPut);
            BufferedReader fileBuffer = new BufferedReader(new InputStreamReader(conn));
            while ((line = fileBuffer.readLine()) != null) {
                pw.println(line);
            }
            pw.flush();
            pw.close();
            outPut.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return tempFile;
    }

    private InputStream downloadAndGetInputStream(String pdbId) throws IOException {
        File tmp = this.downloadPDB(pdbId);
        if (tmp != null) {
            InputStreamProvider prov = new InputStreamProvider();
            return prov.getInputStream(tmp);
        }
        throw new IOException("could not find PDB " + pdbId + " in file system and also could not download");
    }

    @Override
    public Structure getStructureById(String pdbId) throws IOException {
        InputStream inStream = this.getInputStream(pdbId);
        PDBFileParser pdbpars = new PDBFileParser();
        pdbpars.setParseSecStruc(this.parseSecStruc);
        pdbpars.setAlignSeqRes(this.alignSeqRes);
        pdbpars.setParseCAOnly(this.parseCAOnly);
        Structure struc = pdbpars.parsePDBFile(inStream);
        return struc;
    }

    @Override
    public Structure getStructure(String filename) throws IOException {
        File f = new File(filename);
        return this.getStructure(f);
    }

    public Structure getStructure(File filename) throws IOException {
        InputStreamProvider isp = new InputStreamProvider();
        InputStream inStream = isp.getInputStream(filename);
        PDBFileParser pdbpars = new PDBFileParser();
        pdbpars.setParseSecStruc(this.parseSecStruc);
        pdbpars.setAlignSeqRes(this.alignSeqRes);
        pdbpars.setParseCAOnly(this.parseCAOnly);
        Structure struc = pdbpars.parsePDBFile(inStream);
        return struc;
    }
}

