/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.io.PDBFileParser;
import org.biojava.bio.structure.io.StructureIO;

public class PDBSRSReader
implements StructureIO {
    private BufferedReader getBufferedReader(String pdbId) throws IOException {
        Socket client = null;
        DataInputStream input = null;
        PrintStream output = null;
        String machine = "";
        int port = 0;
        String message = "please set System properties PFETCH_machine and PFETCH_port !";
        try {
            machine = System.getProperty("PFETCH_host");
            String p = System.getProperty("PFETCH_port");
            port = Integer.parseInt(p);
        }
        catch (NullPointerException e) {
            System.err.println(message);
            e.printStackTrace();
            throw new IOException();
        }
        catch (IllegalArgumentException e) {
            System.err.println(message);
            e.printStackTrace();
            throw new IOException();
        }
        if (port == 0) {
            throw new IOException(message);
        }
        if (machine.equals("")) {
            throw new IOException(message);
        }
        System.out.println("contacting: " + machine + " " + port);
        client = new Socket(machine, port);
        client.setSoTimeout(10000);
        System.out.println("socket o.k.");
        input = new DataInputStream(client.getInputStream());
        BufferedReader buf = new BufferedReader(new InputStreamReader(input));
        System.out.println("sending: --pdb " + pdbId.toLowerCase());
        output = new PrintStream(client.getOutputStream());
        output.println("--pdb " + pdbId.toLowerCase());
        output.flush();
        buf.mark(100);
        String line = buf.readLine();
        buf.reset();
        if (line.equals("no match")) {
            System.out.println("first line: " + line);
            throw new IOException("no pdb with code " + pdbId.toLowerCase() + " found");
        }
        return buf;
    }

    @Override
    public Structure getStructureById(String pdbId) throws IOException {
        BufferedReader buf;
        try {
            buf = this.getBufferedReader(pdbId);
        }
        catch (IOException e) {
            return null;
        }
        Structure s = null;
        try {
            PDBFileParser pdbpars = new PDBFileParser();
            s = pdbpars.parsePDBFile(buf);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return s;
    }
}

