/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.BioException;
import org.biojava.bio.alignment.NeedlemanWunsch;
import org.biojava.bio.alignment.SubstitutionMatrix;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class SeqRes2AtomAligner {
    boolean DEBUG = false;
    static final List<String> excludeTypes = new ArrayList<String>();
    private static final FiniteAlphabet alphabet;
    private static final Symbol gapSymbol;
    private static SubstitutionMatrix matrix;
    String alignmentString = "";

    public String getAlignmentString() {
        return this.alignmentString;
    }

    public boolean isDEBUG() {
        return this.DEBUG;
    }

    public void setDEBUG(boolean debug) {
        this.DEBUG = debug;
    }

    private Chain getMatchingAtomRes(Chain seqRes, List<Chain> atomList) throws StructureException {
        for (Chain atom : atomList) {
            if (!atom.getName().equals(seqRes.getName())) continue;
            return atom;
        }
        throw new StructureException("could not match seqres chainID >" + seqRes.getName() + "< to ATOM chains!");
    }

    public void align(Structure s, List<Chain> seqResList) {
        List<Chain> atomList = s.getModel(0);
        for (Chain seqRes : seqResList) {
            try {
                List<Group> seqResGroups;
                boolean noMatchFound;
                Chain atomRes = this.getMatchingAtomRes(seqRes, atomList);
                if (this.DEBUG) {
                    System.out.println("Alignment for chain " + atomRes.getName());
                }
                if (noMatchFound = this.align(seqResGroups = seqRes.getAtomGroups(), atomRes.getAtomGroups())) continue;
                atomRes.setSeqResGroups(seqResGroups);
            }
            catch (StructureException e) {
                e.printStackTrace();
            }
        }
    }

    public String getFullAtomSequence(List<Group> groups) {
        StringBuffer sequence = new StringBuffer();
        for (int i = 0; i < groups.size(); ++i) {
            Group g = groups.get(i);
            if (g instanceof AminoAcid) {
                AminoAcid a = (AminoAcid)g;
                sequence.append(a.getAminoType());
                continue;
            }
            if (excludeTypes.contains(g.getPDBName())) continue;
            sequence.append("X");
        }
        return sequence.toString();
    }

    public boolean align(List<Group> seqRes, List<Group> atomRes) throws StructureException {
        String seq1 = this.getFullAtomSequence(seqRes);
        String seq2 = this.getFullAtomSequence(atomRes);
        SimpleAlignment simpleAli = null;
        try {
            Sequence bjseq1 = ProteinTools.createProteinSequence(seq1, "seq1");
            Sequence bjseq2 = ProteinTools.createProteinSequence(seq2, "seq2");
            NeedlemanWunsch aligner = new NeedlemanWunsch(-2.0, 5.0, 3.0, 3.0, 0.0, matrix);
            Alignment ali = aligner.getAlignment(bjseq1, bjseq2);
            if (!(ali instanceof SimpleAlignment)) {
                throw new Exception("Alignment is not a SimpleAlignment!");
            }
            simpleAli = (SimpleAlignment)ali;
            this.alignmentString = aligner.getAlignmentString();
            if (this.DEBUG) {
                System.out.println(this.alignmentString);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("align seq1 " + seq1);
            System.err.println("align seq2 " + seq2);
        }
        if (simpleAli == null) {
            throw new StructureException("could not align objects!");
        }
        SymbolList lst1 = simpleAli.symbolListForLabel("seq1");
        SymbolList lst2 = simpleAli.symbolListForLabel("seq2");
        boolean noMatchFound = this.mapChains(seqRes, lst1, atomRes, lst2, gapSymbol);
        return noMatchFound;
    }

    private boolean mapChains(List<Group> seqRes, SymbolList lst1, List<Group> atomRes, SymbolList lst2, Symbol gapSymbol) throws StructureException {
        assert (lst1.length() == lst2.length());
        List<Group> seqResGroups = seqRes;
        int aligLength = lst1.length();
        int posSeq = -1;
        int posAtom = -1;
        boolean noMatchFound = true;
        for (int i = 1; i <= aligLength; ++i) {
            Symbol s = lst1.symbolAt(i);
            Symbol a = lst2.symbolAt(i);
            String sn = s.getName();
            String an = a.getName();
            if (!sn.equals("gap") && !sn.equals(gapSymbol.getName())) {
                ++posSeq;
            }
            if (!an.equals("gap") && !an.equals(gapSymbol.getName())) {
                ++posAtom;
            }
            if (!s.getName().equals(a.getName())) continue;
            Group s1 = seqRes.get(posSeq);
            Group a1 = atomRes.get(posAtom);
            String pdbNameS = s1.getPDBName();
            String pdbNameA = a1.getPDBName();
            if (!pdbNameA.equals(pdbNameS) && !pdbNameA.trim().equals(pdbNameS.trim())) {
                System.err.println(s1 + " " + posSeq + " does not align with " + a1 + " " + posAtom);
                throw new StructureException("could not match residues");
            }
            seqResGroups.set(posSeq, a1);
            noMatchFound = false;
        }
        if (noMatchFound && this.DEBUG) {
            System.out.println("no alignment found!");
        }
        return noMatchFound;
    }

    public static SubstitutionMatrix getSubstitutionMatrix(FiniteAlphabet alphabet) throws IOException, BioException {
        InputStream inStream = SeqRes2AtomAligner.class.getResourceAsStream("/org/biojava/bio/structure/blosum62.mat");
        String newline = System.getProperty("line.separator");
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        StringBuffer file = new StringBuffer();
        while (reader.ready()) {
            file.append(reader.readLine());
            file.append(newline);
        }
        SubstitutionMatrix matrix = new SubstitutionMatrix(alphabet, file.toString(), "blosum 62");
        return matrix;
    }

    static {
        excludeTypes.add("HOH");
        excludeTypes.add("DOD");
        alphabet = (FiniteAlphabet)AlphabetManager.alphabetForName("PROTEIN-TERM");
        gapSymbol = alphabet.getGapSymbol();
        try {
            matrix = SeqRes2AtomAligner.getSubstitutionMatrix(alphabet);
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

