/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.server;

import java.io.File;
import org.biojava.bio.structure.PDBHeader;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.server.FlatFileInstallation;
import org.biojava.bio.structure.server.PDBInstallation;
import org.biojava.bio.structure.server.SimpleStructureServer;
import org.biojava.bio.structure.server.StructureEvent;
import org.biojava.bio.structure.server.StructureListener;
import org.biojava.bio.structure.server.StructureServer;

public class DemoStructureServer
implements Runnable,
StructureListener {
    public StructureServer server;

    public static void main(String[] args) {
        File pdbLocation = new File("/path/to/PDB/files");
        FlatFileInstallation installation = new FlatFileInstallation(pdbLocation);
        SimpleStructureServer server = new SimpleStructureServer();
        server.setPDBInstallation(installation);
        server.setCacheSize(2);
        server.initCache();
        DemoStructureServer demo = new DemoStructureServer();
        demo.setServer(server);
        server.addStructureListener(demo);
        Thread t = new Thread(demo);
        t.start();
    }

    public void setServer(StructureServer server) {
        this.server = server;
    }

    @Override
    public void run() {
        this.server.requestNextStructure(this);
    }

    @Override
    public void modifiedStructure(StructureEvent event) {
    }

    @Override
    public synchronized void newStructure(StructureEvent event) {
        System.out.println("demo: got a  new structure from server");
        Structure s = event.getStructure();
        if (s == null) {
            System.out.println("demo got a null = problem with loading " + event.getPDBCode());
        } else {
            System.out.println(s.getPDBCode());
            PDBInstallation installation = this.server.getPDBInstallation();
            PDBHeader header = installation.getPDBHeader(s.getPDBCode());
            System.out.println(header);
        }
        if (this.server.hasNextStructure()) {
            this.server.requestNextStructure(this);
        }
    }

    @Override
    public void obsoleteStructure(StructureEvent event) {
    }
}

