/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.HashSet;
import java.util.Iterator;
import org.biojava.bio.symbol.AbstractTranslationTable;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ReversibleTranslationTable;
import org.biojava.bio.symbol.Symbol;

public abstract class AbstractReversibleTranslationTable
extends AbstractTranslationTable
implements ReversibleTranslationTable {
    @Override
    public abstract Alphabet getSourceAlphabet();

    @Override
    public abstract Alphabet getTargetAlphabet();

    protected abstract Symbol doUntranslate(Symbol var1) throws IllegalSymbolException;

    @Override
    public Symbol untranslate(Symbol sym) throws IllegalSymbolException {
        Symbol s = this.doUntranslate(sym);
        if (s == null) {
            if (sym instanceof AtomicSymbol) {
                this.getSourceAlphabet().validate(sym);
                throw new IllegalSymbolException("Unable to map " + sym.getName());
            }
            if (sym == null) {
                throw new NullPointerException("Can't translate null");
            }
            HashSet<Symbol> syms = new HashSet<Symbol>();
            Iterator i = ((FiniteAlphabet)sym.getMatches()).iterator();
            while (i.hasNext()) {
                Symbol is = (Symbol)i.next();
                syms.add(this.untranslate(is));
            }
            s = this.getTargetAlphabet().getAmbiguity(syms);
        }
        return s;
    }
}

