/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import junit.framework.TestCase;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractSymbolEventTest
extends TestCase {
    Annotation ann;
    Symbol sym;

    protected void setUp() throws Exception {
        SmallAnnotation initialAnno = new SmallAnnotation();
        this.sym = this.createSymbol(initialAnno);
        this.ann = this.sym.getAnnotation();
    }

    protected abstract Symbol createSymbol(Annotation var1) throws Exception;

    protected void doChange() {
        try {
            this.ann.setProperty("pigs", "dogs");
        }
        catch (ChangeVetoException e) {
            throw new AssertionFailure(e);
        }
    }

    public void testUnknown() {
        EventCounter uc = new EventCounter("unknown");
        this.sym.addChangeListener(uc, ChangeType.UNKNOWN);
        this.doChange();
        AbstractSymbolEventTest.assertEquals((String)"Prechange fired", (int)1, (int)uc.getPre());
        AbstractSymbolEventTest.assertEquals((String)"Postchange fired", (int)1, (int)uc.getPost());
    }

    public void testAnnotation() {
        EventCounter an = new EventCounter("annotation");
        this.sym.addChangeListener(an, Annotatable.ANNOTATION);
        this.doChange();
        AbstractSymbolEventTest.assertEquals((String)"Prechange fired", (int)1, (int)an.getPre());
        AbstractSymbolEventTest.assertEquals((String)"Postchange fired", (int)1, (int)an.getPost());
    }

    public void testProperty() {
        EventCounter pr = new EventCounter("property");
        this.sym.addChangeListener(pr, Annotation.PROPERTY);
        this.doChange();
        AbstractSymbolEventTest.assertEquals((String)"Prechange fired", (int)0, (int)pr.getPre());
        AbstractSymbolEventTest.assertEquals((String)"Postchange fired", (int)0, (int)pr.getPost());
    }

    public void testUnknownAnnotation() {
        EventCounter uc = new EventCounter("unknown");
        EventCounter an = new EventCounter("annotation");
        this.sym.addChangeListener(uc, ChangeType.UNKNOWN);
        this.sym.addChangeListener(an, Annotatable.ANNOTATION);
        this.doChange();
        AbstractSymbolEventTest.assertEquals((String)"Prechange fired", (int)1, (int)uc.getPre());
        AbstractSymbolEventTest.assertEquals((String)"Postchange fired", (int)1, (int)uc.getPost());
        AbstractSymbolEventTest.assertEquals((String)"Prechange fired", (int)1, (int)an.getPre());
        AbstractSymbolEventTest.assertEquals((String)"Postchange fired", (int)1, (int)an.getPost());
    }

    public void testUnknownProptery() {
        EventCounter uc = new EventCounter("unknown");
        EventCounter pr = new EventCounter("property");
        this.sym.addChangeListener(uc, ChangeType.UNKNOWN);
        this.sym.addChangeListener(pr, Annotation.PROPERTY);
        this.doChange();
        AbstractSymbolEventTest.assertEquals((String)"Prechange fired", (int)1, (int)uc.getPre());
        AbstractSymbolEventTest.assertEquals((String)"Postchange fired", (int)1, (int)uc.getPost());
        AbstractSymbolEventTest.assertEquals((String)"Prechange fired", (int)0, (int)pr.getPre());
        AbstractSymbolEventTest.assertEquals((String)"Postchange fired", (int)0, (int)pr.getPost());
    }

    public void testUnknownAnnotationProperty() {
        EventCounter uc = new EventCounter("unknown");
        EventCounter an = new EventCounter("annotation");
        EventCounter pr = new EventCounter("property");
        this.sym.addChangeListener(uc, ChangeType.UNKNOWN);
        this.sym.addChangeListener(an, Annotatable.ANNOTATION);
        this.sym.addChangeListener(pr, Annotation.PROPERTY);
        this.doChange();
        AbstractSymbolEventTest.assertEquals((String)"Prechange fired", (int)1, (int)uc.getPre());
        AbstractSymbolEventTest.assertEquals((String)"Postchange fired", (int)1, (int)uc.getPost());
        AbstractSymbolEventTest.assertEquals((String)"Prechange fired", (int)1, (int)an.getPre());
        AbstractSymbolEventTest.assertEquals((String)"Postchange fired", (int)1, (int)an.getPost());
        AbstractSymbolEventTest.assertEquals((String)"Prechange fired", (int)0, (int)pr.getPre());
        AbstractSymbolEventTest.assertEquals((String)"Postchange fired", (int)0, (int)pr.getPost());
    }

    public void testAnnotationUnknown() {
        EventCounter an = new EventCounter("annotation");
        EventCounter uc = new EventCounter("unknown");
        this.sym.addChangeListener(an, Annotatable.ANNOTATION);
        this.sym.addChangeListener(uc, ChangeType.UNKNOWN);
        this.doChange();
        AbstractSymbolEventTest.assertEquals((String)"Prechange fired", (int)1, (int)uc.getPre());
        AbstractSymbolEventTest.assertEquals((String)"Postchange fired", (int)1, (int)uc.getPost());
        AbstractSymbolEventTest.assertEquals((String)"Prechange fired", (int)1, (int)an.getPre());
        AbstractSymbolEventTest.assertEquals((String)"Postchange fired", (int)1, (int)an.getPost());
    }

    private class EventCounter
    implements ChangeListener {
        private final String name;
        private int pre = 0;
        private int post = 0;

        public EventCounter(String name) {
            this.name = name;
        }

        @Override
        public void preChange(ChangeEvent cev) throws ChangeVetoException {
            ++this.pre;
        }

        @Override
        public void postChange(ChangeEvent cev) {
            ++this.post;
        }

        public void clear() {
            this.pre = 0;
            this.post = 0;
        }

        public int getPre() {
            return this.pre;
        }

        public int getPost() {
            return this.post;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

