/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;

public class AlphabetManagerTest
extends TestCase {
    public AlphabetManagerTest(String s) {
        super(s);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testAlphabetForName() {
        String name1 = "DNA";
        String name2 = "PROTEIN";
        String name3 = "(DNA x DNA x DNA)";
        String name4 = "((DNA x DNA x DNA) x PROTEIN)";
        String name5 = "(PROTEIN x (DNA x DNA x DNA))";
        String name6 = "((DNA x DNA x DNA) x DNA x (PROTEIN x DNA))";
        try {
            Alphabet alphabetRet = AlphabetManager.alphabetForName(name1);
            AlphabetManagerTest.assertEquals((Object)DNATools.getDNA(), (Object)alphabetRet);
            alphabetRet = AlphabetManager.alphabetForName(name2);
            AlphabetManagerTest.assertEquals((Object)ProteinTools.getAlphabet(), (Object)alphabetRet);
            alphabetRet = AlphabetManager.alphabetForName(name3);
            AlphabetManagerTest.assertEquals((String)alphabetRet.getName(), (String)name3);
            alphabetRet = AlphabetManager.alphabetForName(name4);
            AlphabetManagerTest.assertEquals((String)alphabetRet.getName(), (String)name4);
            alphabetRet = AlphabetManager.alphabetForName(name5);
            AlphabetManagerTest.assertEquals((String)alphabetRet.getName(), (String)name5);
            alphabetRet = AlphabetManager.alphabetForName(name6);
            AlphabetManagerTest.assertEquals((String)alphabetRet.getName(), (String)name6);
        }
        catch (Exception e) {
            System.err.println("Exception thrown:  " + e);
        }
    }

    public void testGetAllSymbols() throws Exception {
        FiniteAlphabet dna = DNATools.getDNA();
        Set allDna = AlphabetManager.getAllSymbols(dna);
        Symbol n = DNATools.n();
        Set allN = AlphabetManager.getAllSymbols((FiniteAlphabet)n.getMatches());
        AlphabetManagerTest.assertEquals((int)allDna.size(), (int)16);
        AlphabetManagerTest.assertEquals((int)allN.size(), (int)16);
        for (Symbol is : allN) {
            boolean found = false;
            for (Symbol js : allDna) {
                if (is != js) continue;
                found = true;
            }
            AlphabetManagerTest.assertTrue((boolean)found);
        }
    }

    public void testSharedSymbols() throws Exception {
        FiniteAlphabet protein = ProteinTools.getAlphabet();
        String protString = "RVQZ";
        SimpleSymbolList sl_protein = new SimpleSymbolList(protein.getTokenization("token"), protString);
        SimpleSymbolList sl_proteinT = new SimpleSymbolList(protein.getTokenization("token"), protString);
        for (int i = 1; i <= sl_protein.length(); ++i) {
            AlphabetManagerTest.assertEquals((Object)sl_protein.symbolAt(i), (Object)sl_proteinT.symbolAt(i));
        }
    }

    public void testGapInCrossProductAlphabet() throws Exception {
        FiniteAlphabet protein = ProteinTools.getAlphabet();
        Alphabet alph = AlphabetManager.getCrossProductAlphabet(Collections.nCopies(2, protein));
        ArrayList<Symbol> s = new ArrayList<Symbol>();
        s.add(protein.getGapSymbol());
        s.add(ProteinTools.createProtein("V").symbolAt(1));
        Symbol sym = alph.getSymbol(s);
        List l = ((BasisSymbol)sym).getSymbols();
        AlphabetManagerTest.assertEquals(s.get(0), l.get(0));
        AlphabetManagerTest.assertEquals(s.get(1), l.get(1));
    }
}

