/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import junit.framework.TestCase;
import org.biojava.bio.Annotation;
import org.biojava.bio.program.phred.PhredTools;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.DoubleAlphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.SimpleAlphabet;

public class AlphabetSerializationTest
extends TestCase {
    IntegerAlphabet integer;
    IntegerAlphabet.SubIntegerAlphabet subint;
    DoubleAlphabet.SubDoubleAlphabet subdoub;
    DoubleAlphabet doub;
    FiniteAlphabet phred;
    FiniteAlphabet dna;
    SimpleAlphabet custom;

    public AlphabetSerializationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.integer = IntegerAlphabet.getInstance();
        this.subint = IntegerAlphabet.getSubAlphabet(20, 99);
        this.doub = DoubleAlphabet.getInstance();
        this.subdoub = DoubleAlphabet.getSubAlphabet(20.0, 99.0);
        this.phred = PhredTools.getPhredAlphabet();
        this.dna = DNATools.getDNA();
        AtomicSymbol s0 = AlphabetManager.createSymbol("foo", Annotation.EMPTY_ANNOTATION);
        AtomicSymbol s1 = AlphabetManager.createSymbol("goo", Annotation.EMPTY_ANNOTATION);
        AtomicSymbol s2 = AlphabetManager.createSymbol("hoo", Annotation.EMPTY_ANNOTATION);
        HashSet<AtomicSymbol> set = new HashSet<AtomicSymbol>(3);
        set.add(s0);
        set.add(s1);
        set.add(s2);
        this.custom = new SimpleAlphabet(set, "custom_test");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIntegerSerialization() throws Exception {
        IntegerAlphabet integer2 = (IntegerAlphabet)this.serialize(this.integer);
        AlphabetSerializationTest.assertTrue((this.integer == integer2 ? 1 : 0) != 0);
        AlphabetSerializationTest.assertTrue((boolean)this.integer.equals(integer2));
        AlphabetSerializationTest.assertTrue((this.integer.getSymbol(12) == integer2.getSymbol(12) ? 1 : 0) != 0);
        AlphabetSerializationTest.assertTrue((boolean)this.integer.getSymbol(12).equals(integer2.getSymbol(12)));
        AlphabetSerializationTest.assertTrue((!this.integer.getSymbol(12).equals(integer2.getSymbol(13)) ? 1 : 0) != 0);
    }

    public void testDoubleSerialization() throws Exception {
        DoubleAlphabet doub2 = (DoubleAlphabet)this.serialize(this.doub);
        AlphabetSerializationTest.assertTrue((this.doub == doub2 ? 1 : 0) != 0);
        AlphabetSerializationTest.assertTrue((boolean)this.doub.equals(doub2));
        AlphabetSerializationTest.assertTrue((this.doub.getSymbol(12.0) == doub2.getSymbol(12.0) ? 1 : 0) != 0);
        AlphabetSerializationTest.assertTrue((boolean)this.doub.getSymbol(12.0).equals(doub2.getSymbol(12.0)));
        AlphabetSerializationTest.assertTrue((!this.doub.getSymbol(12.0).equals(doub2.getSymbol(13.0)) ? 1 : 0) != 0);
    }

    public void testSubInt() throws Exception {
        IntegerAlphabet.SubIntegerAlphabet subint2 = (IntegerAlphabet.SubIntegerAlphabet)this.serialize(this.subint);
        AlphabetSerializationTest.assertTrue((this.subint == subint2 ? 1 : 0) != 0);
        AlphabetSerializationTest.assertTrue((boolean)this.subint.equals(subint2));
        AlphabetSerializationTest.assertTrue((this.integer.getSymbol(80) == subint2.getSymbol(80) ? 1 : 0) != 0);
        AlphabetSerializationTest.assertTrue((this.subint.getSymbol(80) == subint2.getSymbol(80) ? 1 : 0) != 0);
        AlphabetSerializationTest.assertTrue((boolean)this.subint.getSymbol(80).equals(subint2.getSymbol(80)));
        AlphabetSerializationTest.assertTrue((this.subint.getSymbol(81) != subint2.getSymbol(80) ? 1 : 0) != 0);
        AlphabetSerializationTest.assertTrue((this.subint.size() == subint2.size() ? 1 : 0) != 0);
    }

    public void testSubDouble() throws Exception {
        DoubleAlphabet.SubDoubleAlphabet subdoub2 = (DoubleAlphabet.SubDoubleAlphabet)this.serialize(this.subdoub);
        AlphabetSerializationTest.assertTrue((this.subdoub == subdoub2 ? 1 : 0) != 0);
        AlphabetSerializationTest.assertTrue((boolean)this.subdoub.equals(subdoub2));
        AlphabetSerializationTest.assertTrue((this.doub.getSymbol(80.0) == subdoub2.getSymbol(80.0) ? 1 : 0) != 0);
        AlphabetSerializationTest.assertTrue((this.subdoub.getSymbol(80.3) == subdoub2.getSymbol(80.3) ? 1 : 0) != 0);
        AlphabetSerializationTest.assertTrue((boolean)this.subdoub.getSymbol(80.3).equals(subdoub2.getSymbol(80.3)));
        AlphabetSerializationTest.assertTrue((this.subdoub.getSymbol(81.9) != subdoub2.getSymbol(80.0) ? 1 : 0) != 0);
    }

    public void testDNASerialization() throws Exception {
        FiniteAlphabet dna2 = (FiniteAlphabet)this.serialize(this.dna);
        AlphabetSerializationTest.assertTrue((this.dna == dna2 ? 1 : 0) != 0);
        AlphabetSerializationTest.assertTrue((this.dna.size() == dna2.size() ? 1 : 0) != 0);
        AlphabetSerializationTest.assertTrue((boolean)this.equalSymbols(this.dna, dna2));
        AlphabetSerializationTest.assertTrue((boolean)this.dna.getTokenization("token").equals(dna2.getTokenization("token")));
    }

    public void testPhredSerialization() throws Exception {
        FiniteAlphabet phred2 = (FiniteAlphabet)this.serialize(this.phred);
        AlphabetSerializationTest.assertTrue((this.phred == phred2 ? 1 : 0) != 0);
        AlphabetSerializationTest.assertTrue((this.phred.size() == phred2.size() ? 1 : 0) != 0);
        AlphabetSerializationTest.assertTrue((boolean)this.equalSymbols(this.phred, phred2));
    }

    public void testCustom() throws Exception {
        SimpleAlphabet custom2 = this.custom;
        AlphabetSerializationTest.assertTrue((this.custom == custom2 ? 1 : 0) != 0);
        AlphabetSerializationTest.assertTrue((this.custom.size() == this.custom.size() ? 1 : 0) != 0);
        AlphabetSerializationTest.assertTrue((boolean)this.equalSymbols(this.custom, custom2));
    }

    private Object serialize(Object alpha) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(alpha);
        oos.flush();
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(os.toByteArray()));
        Object o = ois.readObject();
        ois.close();
        return o;
    }

    private boolean equalSymbols(FiniteAlphabet alpha, FiniteAlphabet alpha2) {
        AlphabetIndex index1 = AlphabetManager.getAlphabetIndex(alpha);
        AlphabetIndex index2 = AlphabetManager.getAlphabetIndex(alpha2);
        int aSize = alpha.size();
        for (int i = 0; i < aSize; ++i) {
            if (index1.symbolForIndex(i) == index2.symbolForIndex(i)) continue;
            return false;
        }
        return true;
    }
}

