/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractLocationDecorator;
import org.biojava.bio.symbol.BetweenLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.RangeLocation;

public class BetweenLocationTest
extends TestCase {
    private Location betweenFiveSix;
    private Location betweenFiveSeven;
    private Location betweenFiveTen;
    private Location betweenSevenTwelve;
    private Location betweenNineEleven;
    private Location betweenTenEleven;
    private Location rangeOneTen;
    private Location rangeFiveSix;

    public BetweenLocationTest(String theName) {
        super(theName);
    }

    public static void main(String[] args) {
        TestRunner.run(BetweenLocationTest.class);
    }

    public void testIntersectionOneTenBetweenFiveSix() {
        BetweenLocation expected = new BetweenLocation(new RangeLocation(5, 6));
        Location result = LocationTools.intersection(this.rangeOneTen, this.betweenFiveSix);
        this.assertEqual(expected, result);
    }

    public void testIntersectionOneTenBetweenFiveSeven() {
        BetweenLocation expected = new BetweenLocation(new RangeLocation(5, 7));
        Location result = LocationTools.intersection(this.rangeOneTen, this.betweenFiveSeven);
        this.assertEqual(expected, result);
    }

    public void testIntersectionOneTenBetweenTenEleven() {
        Location expected = Location.empty;
        Location result = LocationTools.intersection(this.rangeOneTen, this.betweenTenEleven);
        this.assertEqual(expected, result);
    }

    public void testIntersectionOneTenBetweenNineEleven() {
        BetweenLocation expected = new BetweenLocation(new RangeLocation(9, 10));
        Location result = LocationTools.intersection(this.rangeOneTen, this.betweenNineEleven);
        this.assertEqual(expected, result);
    }

    public void testIntersectionBetweenFiveSixBetweenFiveSix() {
        BetweenLocation expected = new BetweenLocation(new RangeLocation(5, 6));
        Location result = LocationTools.intersection(this.betweenFiveSix, this.betweenFiveSix);
        this.assertEqual(expected, result);
    }

    public void testIntersectionBetweenFiveTenBetweenFiveSix() {
        BetweenLocation expected = new BetweenLocation(new RangeLocation(5, 6));
        Location result = LocationTools.intersection(this.betweenFiveTen, this.betweenFiveSix);
        this.assertEqual(expected, result);
    }

    public void testIntersectionBetweenFiveTenBetweenSevenTwelve() {
        BetweenLocation expected = new BetweenLocation(new RangeLocation(7, 10));
        Location result = LocationTools.intersection(this.betweenFiveTen, this.betweenSevenTwelve);
        this.assertEqual(expected, result);
    }

    public void testOverlapsOneTenBetweenFiveSix() {
        BetweenLocationTest.assertTrue((boolean)LocationTools.overlaps(this.rangeOneTen, this.betweenFiveSix));
    }

    public void testOverlapsOneTenBetweenFiveSeven() {
        BetweenLocationTest.assertTrue((boolean)LocationTools.overlaps(this.rangeOneTen, this.betweenFiveSeven));
    }

    public void testOverlapsOneTenBetweenTenEleven() {
        BetweenLocationTest.assertTrue((!LocationTools.overlaps(this.rangeOneTen, this.betweenTenEleven) ? 1 : 0) != 0);
    }

    public void testOverlapsOneTenBetweenNineEleven() {
        BetweenLocationTest.assertTrue((boolean)LocationTools.overlaps(this.rangeOneTen, this.betweenNineEleven));
    }

    public void testOverlapsBetweenFiveSixBetweenFiveSix() {
        BetweenLocationTest.assertTrue((boolean)LocationTools.overlaps(this.betweenFiveSix, this.betweenFiveSix));
    }

    public void testOverlapsBetweenFiveTenBetweenFiveSix() {
        BetweenLocationTest.assertTrue((boolean)LocationTools.overlaps(this.betweenFiveTen, this.betweenFiveSix));
    }

    public void testOverlapsBetweenFiveTenBetweenSevenTwelve() {
        BetweenLocationTest.assertTrue((boolean)LocationTools.overlaps(this.betweenFiveTen, this.betweenSevenTwelve));
    }

    public void testAreEqualRangeFiveSixBetweenFiveSix() {
        BetweenLocationTest.assertTrue((!LocationTools.areEqual(this.rangeFiveSix, this.betweenFiveSix) ? 1 : 0) != 0);
    }

    public void testAreEqualBetweenFiveSixBetweenFiveSix() {
        BetweenLocationTest.assertTrue((boolean)LocationTools.areEqual(this.betweenFiveSix, this.betweenFiveSix));
    }

    public void testAreEqualBetweenFiveSixBetweenFiveTen() {
        BetweenLocationTest.assertTrue((!LocationTools.areEqual(this.betweenFiveSix, this.betweenFiveTen) ? 1 : 0) != 0);
    }

    public void testContainsOneTenBetweenFiveSix() {
        BetweenLocationTest.assertTrue((boolean)LocationTools.contains(this.rangeOneTen, this.betweenFiveSix));
    }

    public void testContainsBetweenFiveSixOneTen() {
        BetweenLocationTest.assertTrue((!LocationTools.contains(this.betweenFiveSix, this.rangeOneTen) ? 1 : 0) != 0);
    }

    public void testContainsOneTenBetweenFiveSeven() {
        BetweenLocationTest.assertTrue((boolean)LocationTools.contains(this.rangeOneTen, this.betweenFiveSeven));
    }

    public void testContainsOneTenBetweenTenEleven() {
        BetweenLocationTest.assertTrue((!LocationTools.contains(this.rangeOneTen, this.betweenTenEleven) ? 1 : 0) != 0);
    }

    public void testContainsOneTenBetweenNineEleven() {
        BetweenLocationTest.assertTrue((!LocationTools.contains(this.rangeOneTen, this.betweenNineEleven) ? 1 : 0) != 0);
    }

    public void testContainsBetweenFiveSixBetweenFiveSix() {
        BetweenLocationTest.assertTrue((boolean)LocationTools.contains(this.betweenFiveSix, this.betweenFiveSix));
    }

    public void testContainsBetweenFiveTenBetweenFiveSix() {
        BetweenLocationTest.assertTrue((boolean)LocationTools.contains(this.betweenFiveTen, this.betweenFiveSix));
    }

    public void testContainsBetweenFiveSixBetweenFiveTen() {
        BetweenLocationTest.assertTrue((!LocationTools.contains(this.betweenFiveSix, this.betweenFiveTen) ? 1 : 0) != 0);
    }

    public void testContainsBetweenFiveTenBetweenSevenTwelve() {
        BetweenLocationTest.assertTrue((!LocationTools.contains(this.betweenFiveTen, this.betweenSevenTwelve) ? 1 : 0) != 0);
    }

    public void testContainsBetweenSevenTwelveBetweenFiveTen() {
        BetweenLocationTest.assertTrue((!LocationTools.contains(this.betweenSevenTwelve, this.betweenFiveTen) ? 1 : 0) != 0);
    }

    public void testUnionRangeOneTenBetweenFiveSix() {
    }

    public void testUnionRangeOneTenBetweenFiveSeven() {
    }

    public void testUnionRangeOneTenBetweenTenEleven() {
    }

    public void testUnionRangeOneTenBetweenNineEleven() {
    }

    public void testUnionBetweenFiveSixBetweenFiveSix() {
    }

    public void testUnionBetweenFiveTenBetweenFiveSix() {
    }

    public void testUnionBetweenFiveTenBetweenSevenTwelve() {
    }

    protected void setUp() {
        this.betweenFiveSix = new BetweenLocation(new RangeLocation(5, 6));
        this.betweenFiveSeven = new BetweenLocation(new RangeLocation(5, 7));
        this.betweenFiveTen = new BetweenLocation(new RangeLocation(5, 10));
        this.betweenSevenTwelve = new BetweenLocation(new RangeLocation(7, 12));
        this.betweenNineEleven = new BetweenLocation(new RangeLocation(9, 11));
        this.betweenTenEleven = new BetweenLocation(new RangeLocation(10, 11));
        this.rangeOneTen = new RangeLocation(1, 10);
        this.rangeFiveSix = new RangeLocation(5, 6);
    }

    private void assertEqual(Location theLocationA, Location theLocationB) {
        boolean locationAWrapped = false;
        boolean locationBWrapped = false;
        try {
            if (LocationTools.isDecorated(theLocationA)) {
                locationAWrapped = true;
                theLocationA = ((AbstractLocationDecorator)theLocationA).getWrapped();
            }
            if (LocationTools.isDecorated(theLocationB)) {
                locationBWrapped = true;
                theLocationB = ((AbstractLocationDecorator)theLocationB).getWrapped();
            }
        }
        catch (ClassCastException cce) {
            throw new BioError("Not possible: decorated by other than abstract location decorator");
        }
        BetweenLocationTest.assertTrue((String)"The locations do not have the same decorators", (locationAWrapped == locationBWrapped ? 1 : 0) != 0);
        boolean result = LocationTools.areEqual(theLocationA, theLocationB);
        if (!result) {
            BetweenLocationTest.fail((String)("Locations not equal: " + theLocationA + " and " + theLocationB));
        }
    }
}

