/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;

public class ChunkedSymbolList
extends AbstractSymbolList
implements Serializable {
    private SymbolList[] chunks;
    private final int chunkSize;
    private final Alphabet alpha;
    private final int length;
    private transient int currentMin = Integer.MAX_VALUE;
    private transient int currentMax = Integer.MIN_VALUE;
    private transient SymbolList currentChunk = null;

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.currentMin = Integer.MAX_VALUE;
        this.currentMax = Integer.MIN_VALUE;
        this.currentChunk = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.alpha.removeChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    public ChunkedSymbolList(SymbolList[] chunks, int chunkSize, int length, Alphabet alpha) {
        this.chunks = chunks;
        this.chunkSize = chunkSize;
        this.length = length;
        this.alpha = alpha;
        alpha.addChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    @Override
    public Alphabet getAlphabet() {
        return this.alpha;
    }

    @Override
    public int length() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Symbol symbolAt(int pos) {
        int offset;
        --pos;
        ChunkedSymbolList chunkedSymbolList = this;
        synchronized (chunkedSymbolList) {
            if (pos < this.currentMin || pos > this.currentMax) {
                int chnk = pos / this.chunkSize;
                offset = pos % this.chunkSize;
                this.currentMin = pos - offset;
                this.currentMax = this.currentMin + this.chunkSize - 1;
                this.currentChunk = this.chunks[chnk];
            } else {
                offset = pos - this.currentMin;
            }
        }
        return this.currentChunk.symbolAt(offset + 1);
    }

    @Override
    public SymbolList subList(int start, int end) {
        if (start < 1 || end > this.length()) {
            throw new IndexOutOfBoundsException("Sublist index out of bounds " + this.length() + ":" + start + "," + end);
        }
        if (end < start) {
            throw new IllegalArgumentException("end must not be lower than start: start=" + start + ", end=" + end);
        }
        int ato = end - 1;
        int afrom = start - 1;
        int cfrom = afrom / this.chunkSize;
        if (ato / this.chunkSize == cfrom) {
            return this.chunks[cfrom].subList(afrom % this.chunkSize + 1, ato % this.chunkSize + 1);
        }
        return super.subList(start, end);
    }
}

