/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractLocationDecorator;
import org.biojava.bio.symbol.CircularLocationTools;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.SymbolList;

public class CircularLocation
extends AbstractLocationDecorator {
    private final int length;
    private int fivePrimeEnd;
    private int threePrimeEnd;
    private LinkedList fivePrimeSortedBlocks;
    private final boolean overlaps;

    public final int getLength() {
        return this.length;
    }

    public boolean overlapsOrigin() {
        return this.overlaps;
    }

    public CircularLocation(Location wrapped, int length) {
        this(wrapped, length, wrapped.getMin());
    }

    public CircularLocation(Location wrapped, int length, int fivePrimeEnd) {
        super(wrapped);
        this.length = length;
        this.overlaps = CircularLocationTools.overlapsOrigin(this);
        this.fivePrimeSortedBlocks = new LinkedList();
        Iterator i = wrapped.blockIterator();
        while (i.hasNext()) {
            Location loc = (Location)i.next();
            this.fivePrimeSortedBlocks.add(loc);
            if (loc.getMin() != fivePrimeEnd) continue;
            this.fivePrimeEnd = fivePrimeEnd;
        }
        Collections.sort(this.fivePrimeSortedBlocks, Location.naturalOrder);
        while (((Location)this.fivePrimeSortedBlocks.getFirst()).getMin() != this.get5PrimeEnd()) {
            Object o = this.fivePrimeSortedBlocks.removeFirst();
            this.fivePrimeSortedBlocks.addLast(o);
        }
        this.threePrimeEnd = ((Location)this.fivePrimeSortedBlocks.getLast()).getMax();
        if (this.get5PrimeEnd() == 0) {
            throw new IllegalArgumentException("The 5' End must be either the minimum of the wrapped location or the minimum of one of its components");
        }
    }

    @Override
    protected Location decorate(Location loc) {
        return new CircularLocation(loc, this.getLength());
    }

    @Override
    public boolean contains(int p) {
        int pp = p % this.getLength() + super.getMin() / this.getLength();
        return this.getWrapped().contains(pp);
    }

    @Override
    public Location intersection(Location l) {
        return LocationTools.intersection(this, l);
    }

    @Override
    public boolean overlaps(Location l) {
        return LocationTools.overlaps(this, l);
    }

    @Override
    public Location union(Location l) {
        return LocationTools.union(this, l);
    }

    @Override
    public boolean contains(Location l) {
        return LocationTools.contains(this, l);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Location)) {
            return false;
        }
        return LocationTools.areEqual(this, (Location)o);
    }

    public String toString() {
        if (this.fivePrimeSortedBlocks.size() > 1) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.get5PrimeEnd() + ", " + ((Location)this.fivePrimeSortedBlocks.getLast()).getMax() + " {");
            Iterator i = this.fivePrimeSortedBlocks.iterator();
            if (i.hasNext()) {
                sb.append("(" + i.next() + ")");
            }
            while (i.hasNext()) {
                sb.append(", (" + i.next() + ")");
            }
            sb.append("}");
            sb.append("  (circular)");
            return sb.substring(0);
        }
        return this.getWrapped().toString() + " (circular)";
    }

    @Override
    public boolean isContiguous() {
        return this.getWrapped().isContiguous();
    }

    public int get5PrimeEnd() {
        return this.fivePrimeEnd;
    }

    public int get3PrimeEnd() {
        return this.threePrimeEnd;
    }

    @Override
    public int getMin() {
        return super.getMin();
    }

    @Override
    public int getMax() {
        return super.getMax();
    }

    @Override
    public SymbolList symbols(SymbolList seq) {
        ListIterator i = this.fivePrimeBlockIterator();
        SymbolList syms = ((Location)i.next()).symbols(seq);
        while (i.hasNext()) {
            Location loc = (Location)i.next();
            SymbolList add = loc.symbols(seq);
            Edit ed = new Edit(syms.length() + 1, 0, add);
            try {
                syms.edit(ed);
            }
            catch (Exception ex) {
                throw new BioError("Illegal edit operation", ex);
            }
        }
        return syms;
    }

    public ListIterator fivePrimeBlockIterator() {
        return this.fivePrimeSortedBlocks.listIterator();
    }
}

