/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.biojava.bio.symbol.CircularLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.RangeLocation;

public class CircularLocationTest
extends TestCase {
    protected CircularLocation r1;
    protected CircularLocation r2;
    protected CircularLocation r3;
    protected CircularLocation r4;
    protected CircularLocation r5;
    protected CircularLocation r6;
    protected CircularLocation r7;
    protected CircularLocation r8;
    protected CircularLocation r9;

    public CircularLocationTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(CircularLocationTest.class);
    }

    protected void setUp() throws Exception {
        this.r1 = LocationTools.makeCircularLocation(1, 100, 200);
        this.r2 = LocationTools.makeCircularLocation(1, 200, 200);
        this.r3 = LocationTools.makeCircularLocation(105, 300, 200);
        this.r4 = LocationTools.makeCircularLocation(-50, 20, 200);
        this.r5 = LocationTools.makeCircularLocation(90, 110, 200);
        this.r6 = LocationTools.makeCircularLocation(18, 24, 20);
        this.r7 = LocationTools.makeCircularLocation(2, 8, 20);
        this.r8 = LocationTools.makeCircularLocation(2, 7, 20);
        this.r9 = LocationTools.makeCircularLocation(8, 8, 20);
    }

    public void testConstruction() {
        CircularLocationTest.assertTrue((this.r1 != null ? 1 : 0) != 0);
        CircularLocationTest.assertTrue((this.r2 != null ? 1 : 0) != 0);
        CircularLocationTest.assertTrue((this.r3 != null ? 1 : 0) != 0);
        CircularLocationTest.assertTrue((this.r4 != null ? 1 : 0) != 0);
        CircularLocationTest.assertTrue((this.r5 != null ? 1 : 0) != 0);
    }

    public void testEquals() {
        CircularLocationTest.assertEquals((Object)this.r1, (Object)this.r1);
        CircularLocationTest.assertEquals((Object)this.r1, (Object)LocationTools.makeCircularLocation(1, 100, 200));
    }

    public void testToString() {
        CircularLocationTest.assertEquals((String)this.r1.toString(), (String)"[1,100] (circular)");
        CircularLocationTest.assertEquals((String)this.r2.toString(), (String)"[1,200] (circular)");
        CircularLocationTest.assertEquals((String)this.r3.toString(), (String)"105, 100 {([105,200]), ([1,100])}  (circular)");
        CircularLocationTest.assertEquals((String)this.r4.toString(), (String)"150, 20 {([150,200]), ([1,20])}  (circular)");
        CircularLocationTest.assertEquals((String)this.r5.toString(), (String)"[90,110] (circular)");
        CircularLocationTest.assertEquals((String)this.r6.toString(), (String)"18, 4 {([18,20]), ([1,4])}  (circular)");
        CircularLocationTest.assertEquals((String)this.r7.toString(), (String)"[2,8] (circular)");
    }

    public void testAreEqual() {
        CircularLocationTest.assertTrue((boolean)LocationTools.areEqual(this.r1, this.r1));
        CircularLocationTest.assertTrue((boolean)LocationTools.areEqual(this.r1, LocationTools.makeCircularLocation(1, 100, 200)));
    }

    public void testOverlaps() {
        CircularLocationTest.assertTrue((boolean)LocationTools.overlaps(this.r1, this.r1));
        CircularLocationTest.assertTrue((boolean)LocationTools.overlaps(this.r2, this.r2));
        CircularLocationTest.assertTrue((boolean)LocationTools.overlaps(this.r1, this.r2));
        CircularLocationTest.assertTrue((boolean)LocationTools.overlaps(this.r2, this.r1));
        CircularLocationTest.assertTrue((boolean)LocationTools.overlaps(this.r4, this.r2));
        CircularLocationTest.assertTrue((boolean)LocationTools.overlaps(this.r2, this.r4));
        CircularLocationTest.assertTrue((boolean)LocationTools.overlaps(this.r5, this.r3));
        CircularLocationTest.assertTrue((boolean)LocationTools.overlaps(this.r3, this.r5));
        CircularLocationTest.assertTrue((boolean)LocationTools.overlaps(this.r6, this.r7));
        CircularLocationTest.assertTrue((boolean)LocationTools.overlaps(this.r7, this.r6));
        CircularLocationTest.assertTrue((!LocationTools.overlaps(this.r5, this.r4) ? 1 : 0) != 0);
    }

    public void testContains() {
        CircularLocationTest.assertTrue((boolean)LocationTools.contains(this.r2, this.r1));
        CircularLocationTest.assertTrue((boolean)LocationTools.contains(this.r2, this.r3));
        CircularLocationTest.assertTrue((boolean)LocationTools.contains(this.r2, this.r4));
        CircularLocationTest.assertTrue((boolean)LocationTools.contains(this.r2, this.r5));
        CircularLocationTest.assertTrue((boolean)LocationTools.contains(this.r3, this.r4));
        CircularLocationTest.assertTrue((!LocationTools.contains(this.r4, this.r5) ? 1 : 0) != 0);
        CircularLocationTest.assertTrue((!LocationTools.contains(this.r4, this.r3) ? 1 : 0) != 0);
        CircularLocationTest.assertTrue((!LocationTools.contains(this.r1, this.r2) ? 1 : 0) != 0);
        CircularLocationTest.assertTrue((boolean)this.r1.contains(1));
        CircularLocationTest.assertTrue((boolean)this.r1.contains(100));
        CircularLocationTest.assertTrue((boolean)this.r1.contains(202));
        CircularLocationTest.assertTrue((!this.r1.contains(101) ? 1 : 0) != 0);
    }

    public void testIntersection() {
        CircularLocationTest.assertEquals((Object)LocationTools.intersection(this.r1, this.r2), (Object)LocationTools.intersection(this.r2, this.r1));
        CircularLocationTest.assertEquals((Object)LocationTools.intersection(this.r5, this.r4), (Object)Location.empty);
        CircularLocationTest.assertEquals((Object)LocationTools.intersection(this.r4, this.r5), (Object)Location.empty);
    }

    public void testUnion() {
        CircularLocation[] locs;
        CircularLocationTest.assertEquals((Object)this.r1, (Object)LocationTools.union(this.r1, this.r1));
        CircularLocationTest.assertEquals((Object)LocationTools.union(this.r1, this.r2), (Object)LocationTools.union(this.r2, this.r1));
        locs = new CircularLocation[]{LocationTools.makeCircularLocation(13, 14, 20), LocationTools.makeCircularLocation(18, 4, 20), (CircularLocation)LocationTools.union(locs[0], locs[1])};
        CircularLocationTest.assertTrue((locs[2].get5PrimeEnd() == 13 ? 1 : 0) != 0);
        CircularLocationTest.assertEquals((String)locs[2].toString(), (String)"13, 4 {([13,14]), ([18,20]), ([1,4])}  (circular)");
        ArrayList<CircularLocation> al = new ArrayList<CircularLocation>();
        al.add(LocationTools.makeCircularLocation(5, 8, 20));
        al.add(LocationTools.makeCircularLocation(7, 16, 20));
        al.add(LocationTools.makeCircularLocation(19, 2, 20));
        CircularLocation loc = (CircularLocation)LocationTools.union(al);
        CircularLocationTest.assertTrue((loc.get5PrimeEnd() == 5 ? 1 : 0) != 0);
        CircularLocationTest.assertTrue((boolean)loc.overlapsOrigin());
        Iterator blocki = loc.blockIterator();
        Location locA = (Location)blocki.next();
        CircularLocationTest.assertTrue((locA.getMin() == 1 ? 1 : 0) != 0);
        CircularLocationTest.assertTrue((locA.getMax() == 2 ? 1 : 0) != 0);
        Location locB = (Location)blocki.next();
        CircularLocationTest.assertTrue((locB.getMin() == 5 ? 1 : 0) != 0);
        CircularLocationTest.assertTrue((locB.getMax() == 16 ? 1 : 0) != 0);
        Location locC = (Location)blocki.next();
        CircularLocationTest.assertTrue((locC.getMin() == 19 ? 1 : 0) != 0);
        CircularLocationTest.assertTrue((locC.getMax() == 20 ? 1 : 0) != 0);
        CircularLocationTest.assertTrue((!blocki.hasNext() ? 1 : 0) != 0);
        CircularLocationTest.assertEquals((Object)this.r7, (Object)LocationTools.union(this.r8, this.r9));
    }

    public void testIsContiguous() {
        CircularLocationTest.assertTrue((boolean)this.r1.isContiguous());
        CircularLocationTest.assertTrue((boolean)this.r2.isContiguous());
        CircularLocationTest.assertTrue((!this.r3.isContiguous() ? 1 : 0) != 0);
        CircularLocationTest.assertTrue((!this.r4.isContiguous() ? 1 : 0) != 0);
        CircularLocationTest.assertTrue((boolean)this.r5.isContiguous());
        Location l = LocationTools.union(new RangeLocation(1, 4), new RangeLocation(7, 10));
        CircularLocation cl = new CircularLocation(l, 200);
        CircularLocationTest.assertTrue((!cl.isContiguous() ? 1 : 0) != 0);
    }
}

