/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.RangeLocation;

public class CompoundLocationTest
extends TestCase {
    protected Location r1;
    protected Location r2;
    protected Location r3;
    protected Location r4;
    protected Location r5;
    protected Location r6;
    protected Location r7;
    protected Location r8;
    protected Location r9;
    private List locs1;
    private List locs2;
    private List locs3;
    private List locs4;
    private List locs5;
    private List locs6;
    private List locs7;
    private List locs8;
    private List locs9;

    public CompoundLocationTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(CompoundLocationTest.class);
    }

    protected void setUp() throws Exception {
        this.locs1 = new ArrayList();
        this.locs1.add(new RangeLocation(1, 100));
        this.locs1.add(new RangeLocation(150, 200));
        this.locs2 = new ArrayList();
        this.locs2.add(new RangeLocation(150, 160));
        this.locs2.add(new RangeLocation(170, 190));
        this.locs3 = new ArrayList();
        this.locs3.add(new RangeLocation(250, 300));
        this.locs3.add(new RangeLocation(350, 400));
        this.locs4 = new ArrayList();
        this.locs5 = new ArrayList();
        this.locs6 = new ArrayList();
        this.locs7 = new ArrayList();
        for (int i = 0; i < 173; ++i) {
            int j = i * 17;
            this.locs4.add(new RangeLocation(j, j + 6));
            this.locs5.add(new RangeLocation(j + 5, j + 8));
            this.locs6.add(new RangeLocation(j + 5, j + 6));
            this.locs7.add(new RangeLocation(j + 10, j + 11));
        }
        this.locs8 = new ArrayList();
        this.locs8.add(new RangeLocation(250, 255));
        this.locs8.add(new RangeLocation(350, 400));
        this.locs9 = new ArrayList();
        this.locs9.add(new RangeLocation(256, 300));
        this.locs9.add(new RangeLocation(350, 400));
        this.r1 = LocationTools.buildLoc(this.locs1);
        this.r2 = LocationTools.buildLoc(this.locs2);
        this.r3 = LocationTools.buildLoc(this.locs3);
        this.r4 = LocationTools.buildLoc(this.locs4);
        this.r5 = LocationTools.buildLoc(this.locs5);
        this.r6 = LocationTools.buildLoc(this.locs6);
        this.r7 = LocationTools.buildLoc(this.locs7);
        this.r8 = LocationTools.buildLoc(this.locs8);
        this.r9 = LocationTools.buildLoc(this.locs9);
    }

    public void testEquals() {
        CompoundLocationTest.assertEquals((Object)this.r1, (Object)this.r1);
        CompoundLocationTest.assertEquals((Object)this.r1, (Object)LocationTools.buildLoc(this.locs1));
    }

    public void testAreEqual() {
        CompoundLocationTest.assertTrue((boolean)LocationTools.areEqual(this.r1, this.r1));
        CompoundLocationTest.assertEquals((Object)this.r1, (Object)LocationTools.buildLoc(this.locs1));
    }

    public void testOverlaps() {
        CompoundLocationTest.assertTrue((boolean)LocationTools.overlaps(this.r1, this.r2));
        CompoundLocationTest.assertTrue((!LocationTools.overlaps(this.r1, this.r3) ? 1 : 0) != 0);
    }

    public void testContains() {
        CompoundLocationTest.assertTrue((boolean)LocationTools.contains(this.r1, this.r2));
        CompoundLocationTest.assertTrue((!LocationTools.contains(this.r1, this.r3) ? 1 : 0) != 0);
        CompoundLocationTest.assertTrue((boolean)this.r1.contains(1));
        CompoundLocationTest.assertTrue((boolean)this.r1.contains(100));
        CompoundLocationTest.assertTrue((boolean)this.r1.contains(150));
        CompoundLocationTest.assertTrue((boolean)this.r1.contains(200));
        CompoundLocationTest.assertTrue((!this.r1.contains(101) ? 1 : 0) != 0);
        CompoundLocationTest.assertTrue((!this.r1.contains(201) ? 1 : 0) != 0);
    }

    public void testIntersection() {
        CompoundLocationTest.assertEquals((Object)LocationTools.intersection(this.r1, this.r2), (Object)LocationTools.intersection(this.r2, this.r1));
        CompoundLocationTest.assertEquals((Object)LocationTools.intersection(this.r1, this.r3), (Object)Location.empty);
        CompoundLocationTest.assertEquals((Object)LocationTools.intersection(this.r3, this.r1), (Object)Location.empty);
        CompoundLocationTest.assertEquals((Object)LocationTools.intersection(this.r1, new RangeLocation(1, 1000)), (Object)this.r1);
        CompoundLocationTest.assertEquals((Object)LocationTools.intersection(new RangeLocation(1, 1000), this.r1), (Object)this.r1);
    }

    public void testUnion() {
        CompoundLocationTest.assertEquals((Object)this.r1, (Object)LocationTools.union(this.r1, this.r1));
        CompoundLocationTest.assertEquals((Object)this.r2, (Object)LocationTools.union(this.r2, this.r2));
        CompoundLocationTest.assertEquals((Object)LocationTools.union(this.r1, this.r2), (Object)LocationTools.union(this.r2, this.r1));
        CompoundLocationTest.assertEquals((Object)LocationTools.union(this.r1, this.r3), (Object)LocationTools.union(this.r3, this.r1));
        CompoundLocationTest.assertEquals((Object)this.r3, (Object)LocationTools.union(this.r8, this.r9));
    }

    public void testIsContiguous() {
        CompoundLocationTest.assertTrue((!this.r1.isContiguous() ? 1 : 0) != 0);
        ArrayList<RangeLocation> single = new ArrayList<RangeLocation>();
        single.add(new RangeLocation(1, 100));
        Location contig = LocationTools.buildLoc(single);
        CompoundLocationTest.assertTrue((boolean)contig.isContiguous());
    }

    public void testOverlapsBig() {
        CompoundLocationTest.assertTrue((boolean)LocationTools.overlaps(this.r4, this.r5));
        CompoundLocationTest.assertTrue((!LocationTools.overlaps(this.r4, this.r7) ? 1 : 0) != 0);
    }

    public void testContainsBig() {
        CompoundLocationTest.assertTrue((boolean)LocationTools.contains(this.r4, this.r6));
        CompoundLocationTest.assertTrue((!LocationTools.contains(this.r4, this.r5) ? 1 : 0) != 0);
        CompoundLocationTest.assertTrue((!LocationTools.contains(this.r4, this.r7) ? 1 : 0) != 0);
    }

    public void testIntersectionBig() {
        CompoundLocationTest.assertEquals((Object)LocationTools.intersection(this.r4, this.r5), (Object)this.r6);
        CompoundLocationTest.assertEquals((Object)LocationTools.intersection(this.r4, this.r7), (Object)Location.empty);
    }

    public void testSubtract() {
        RangeLocation l1 = new RangeLocation(100, 200);
        Location l2 = LocationTools.union(new RangeLocation(100, 119), new RangeLocation(180, 200));
        CompoundLocationTest.assertEquals((Object)LocationTools.subtract(l1, new RangeLocation(120, 179)), (Object)l2);
        CompoundLocationTest.assertEquals((Object)LocationTools.subtract(l1, new RangeLocation(80, 119)), (Object)new RangeLocation(120, 200));
        CompoundLocationTest.assertEquals((Object)LocationTools.subtract(l1, new RangeLocation(180, 1019)), (Object)new RangeLocation(100, 179));
        CompoundLocationTest.assertEquals((Object)LocationTools.subtract(l2, Location.empty), (Object)l2);
    }
}

