/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.Arrays;
import java.util.Iterator;
import junit.framework.TestCase;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.CrossProductAlphabetIndex;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.Symbol;

public class CrossProductAlphabetIndexTest
extends TestCase {
    IntegerAlphabet.SubIntegerAlphabet subint;
    FiniteAlphabet dna;
    FiniteAlphabet prot;
    FiniteAlphabet product;
    AlphabetIndex index;

    public CrossProductAlphabetIndexTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.subint = IntegerAlphabet.getSubAlphabet(20, 99);
        this.dna = DNATools.getDNA();
        this.prot = ProteinTools.getAlphabet();
        this.product = (FiniteAlphabet)AlphabetManager.getCrossProductAlphabet(Arrays.asList(this.subint, this.dna, this.prot));
        this.index = new CrossProductAlphabetIndex(this.product);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIndex2Symbol() throws Exception {
        for (int i = 0; i < this.product.size(); ++i) {
            this.product.validate(this.index.symbolForIndex(i));
        }
    }

    public void testSymbol2Index() throws Exception {
        Iterator i = this.product.iterator();
        while (i.hasNext()) {
            Symbol s = (Symbol)i.next();
            int j = this.index.indexForSymbol(s);
            CrossProductAlphabetIndexTest.assertTrue((j >= 0 && j < this.product.size() ? 1 : 0) != 0);
        }
    }

    public void testISI() throws Exception {
        for (int i = 0; i < this.product.size(); ++i) {
            CrossProductAlphabetIndexTest.assertTrue((String)("index = index->symbol->index\t" + i + " -> " + this.index.symbolForIndex(i) + " -> " + this.index.indexForSymbol(this.index.symbolForIndex(i))), (i == this.index.indexForSymbol(this.index.symbolForIndex(i)) ? 1 : 0) != 0);
        }
    }

    public void testSIS() throws Exception {
        Iterator i = this.product.iterator();
        while (i.hasNext()) {
            Symbol s = (Symbol)i.next();
            CrossProductAlphabetIndexTest.assertTrue((String)("symbol = symbol -> index -> symbol\t" + s + " -> " + this.index.indexForSymbol(s) + " -> " + this.index.symbolForIndex(this.index.indexForSymbol(s))), (s == this.index.symbolForIndex(this.index.indexForSymbol(s)) ? 1 : 0) != 0);
        }
    }

    public static void main(String[] args) throws Throwable {
        CrossProductAlphabetIndexTest test = new CrossProductAlphabetIndexTest("test");
        test.setUp();
        test.testIndex2Symbol();
        test.testSymbol2Index();
        test.testISI();
        test.testSIS();
        test.tearDown();
    }
}

